/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.dotf;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.teamabyssalofficial.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.LoadingPacket;
import net.teamabyssalofficial.entity.client.renderer.CarrierFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.DeadHumanFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.DeadPlayerFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.DeadSangheiliFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.DeadVillagerFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.HumanFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.PlayerFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.PodInfectorRenderer;
import net.teamabyssalofficial.entity.client.renderer.SangheiliFormRenderer;
import net.teamabyssalofficial.entity.client.renderer.VillagerFormRenderer;
import net.teamabyssalofficial.event.SpawnPlacementEvent;
import net.teamabyssalofficial.guns.client.renderer.AbstractBulletRenderer;
import net.teamabyssalofficial.guns.client.renderer.BulletProjectileRenderer;
import net.teamabyssalofficial.guns.gun.GunRegistry;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import net.teamabyssalofficial.guns.packet.ClientAnimationPacket;
import net.teamabyssalofficial.guns.packet.ServerAnimationPacket;
import net.teamabyssalofficial.registry.BannerPatternRegistry;
import net.teamabyssalofficial.registry.BlockEntityRegistry;
import net.teamabyssalofficial.registry.BlockRegistry;
import net.teamabyssalofficial.registry.CreativeTabRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ItemRegistry;
import net.teamabyssalofficial.registry.PaintingRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.BiomeModification;
import org.slf4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="dotf")
public class DawnOfTheFlood {
    public static final String MODID = "dotf";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static boolean isGeckoLibLoaded = false;
    public static boolean isClockworkLibLoaded = false;
    public static boolean isFabridgeLoaded = false;
    public static final ResourceLocation RECOIL_PACKET_ID = new ResourceLocation("dotf", "recoil");
    public static final ResourceLocation RELOAD_PACKET_ID = new ResourceLocation("dotf", "reload");
    public static final ResourceLocation RELOAD_RECOIL_PACKET_ID = new ResourceLocation("dotf", "reload_recoil");
    public static final ResourceLocation INSPECT_PACKET_ID = new ResourceLocation("dotf", "inspect");
    public static final ResourceLocation GUN_AIM_PACKET_ID = new ResourceLocation("dotf", "aim");
    public static final ResourceLocation GUN_SPRINT_PACKET_ID = new ResourceLocation("dotf", "sprint");
    public static final ResourceLocation PLAY_ANIMATION_PACKET_ID = new ResourceLocation("dotf", "play_animation");

    public DawnOfTheFlood() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DawnOfTheFloodConfig.DATAGEN_SPEC, "dotf_data.toml");
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)DawnOfTheFloodConfig.SERVER_SPEC, "dotf_config.toml");
        DawnOfTheFloodConfig.loadConfig(DawnOfTheFloodConfig.SERVER_SPEC, FMLPaths.CONFIGDIR.get().resolve("dotf_config.toml").toString());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModLoadingContext context = ModLoadingContext.get();
        MinecraftForge.EVENT_BUS.register((Object)this);
        new ServerAnimationPacket().onInitialize();
        GeckoLib.initialize();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(SpawnPlacementEvent::SpawnPlacement);
        modEventBus.addListener(this::commonSetup);
        EntityRegistry.register(modEventBus);
        ItemRegistry.register(modEventBus);
        GunRegistry.registerGuns(modEventBus);
        BlockRegistry.register(modEventBus);
        BlockEntityRegistry.register(modEventBus);
        SoundRegistry.register(modEventBus);
        EffectRegistry.register(modEventBus);
        ParticleRegistry.register(modEventBus);
        PaintingRegistry.register(modEventBus);
        CreativeTabRegistry.register(modEventBus);
        BannerPatternRegistry.register(modEventBus);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(KeybindHelper::registerKeyMappings));
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MODID);
        biomeModifiers.register(modEventBus);
        biomeModifiers.register("dotf_spawns", BiomeModification::makeCodec);
        isGeckoLibLoaded = ModList.get().isLoaded("geckolib");
        isClockworkLibLoaded = ModList.get().isLoaded("clockwork");
        isFabridgeLoaded = ModList.get().isLoaded("fabridge");
        new LoadingPacket().onInitialize();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    @Mod.EventBusSubscriber(modid="dotf", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
            new ClientAnimationPacket().onInitialize();
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.POD_INFECTOR.get()), PodInfectorRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.HUMAN_FORM.get()), HumanFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.PLAYER_FORM.get()), PlayerFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.VILLAGER_FORM.get()), VillagerFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.CARRIER_FORM.get()), CarrierFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.SANGHEILI_FORM.get()), SangheiliFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.DEAD_HUMAN_FORM.get()), DeadHumanFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.DEAD_PLAYER_FORM.get()), DeadPlayerFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.DEAD_VILLAGER_FORM.get()), DeadVillagerFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.DEAD_SANGHEILI_FORM.get()), DeadSangheiliFormRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.BULLET.get()), AbstractBulletRenderer::new);
            EntityRenderers.m_174036_((EntityType)((EntityType)EntityRegistry.BULLET_PROJECTILE.get()), BulletProjectileRenderer::new);
        }
    }
}

