/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.asestefan.utils.ParticleUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.categories.BodyEntity;
import net.teamabyssalofficial.entity.custom.DeadHumanFormEntity;
import net.teamabyssalofficial.entity.custom.DeadPlayerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadSangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.DeadVillagerFormEntity;
import net.teamabyssalofficial.entity.custom.HumanFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.VillagerFormEntity;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;

public class ReanimateOthersGoal
extends Goal {
    private static TargetingConditions PARTNER_TARGETING;
    protected final Level level;
    protected final PathfinderMob mob;
    private final Class<? extends PathfinderMob> partnerClass;
    @Nullable
    protected PathfinderMob partner;
    private final double speedModifier;

    public ReanimateOthersGoal(PathfinderMob mob, double speedModifier) {
        this(mob, speedModifier, mob.getClass());
    }

    public ReanimateOthersGoal(PathfinderMob mob, double speedModifier, Class<? extends PathfinderMob> partnerClass) {
        this(mob, speedModifier, partnerClass, null);
    }

    public ReanimateOthersGoal(PathfinderMob mob, double speedModifier, Class<? extends PathfinderMob> partnerClass, @Nullable Predicate<LivingEntity> en) {
        this.level = mob.m_9236_();
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.partnerClass = partnerClass;
        PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(32.0).m_26888_(en);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_217043_().m_188503_(15) == 0 && this.getFreePartner() == null) {
            return false;
        }
        if (this.mob.m_217043_().m_188503_(5) == 1) {
            this.partner = this.getFreePartner();
        }
        return this.partnerClass != null;
    }

    public boolean m_8045_() {
        if (this.partner != null) {
            return this.partner.m_6084_() || this.getFreePartner() != null;
        }
        return false;
    }

    public void m_8041_() {
        this.partner = null;
    }

    public boolean canTake(Entity entity) {
        BodyEntity bodyEntity;
        return entity instanceof BodyEntity && !(bodyEntity = (BodyEntity)entity).isTaken();
    }

    public void take(Entity entity) {
        BodyEntity bodyEntity;
        if (entity instanceof BodyEntity && !(bodyEntity = (BodyEntity)entity).isTaken()) {
            bodyEntity.setTaken(true);
        }
    }

    public void m_8037_() {
        if (this.partner != null && this.canTake((Entity)this.partner)) {
            this.mob.m_21573_().m_5624_((Entity)this.partner, this.speedModifier);
            if (this.mob.m_20270_((Entity)this.partner) <= 2.0f && this.mob.m_217043_().m_188503_(3) == 0) {
                this.reanimateForms((Entity)this.partner);
                this.take((Entity)this.partner);
                this.playReanimationSound(this.partner.m_9236_(), (Entity)this.partner);
                this.generateParticles(this.partner.m_9236_(), (Entity)this.partner, this.partner.m_217043_());
                this.mob.m_146870_();
                this.partner.m_146870_();
                this.m_8041_();
            }
        }
    }

    private void reanimateForms(Entity entity) {
        if (entity instanceof DeadHumanFormEntity) {
            DeadHumanFormEntity deadHumanFormEntity = (DeadHumanFormEntity)entity;
            HumanFormEntity humanFormEntity = new HumanFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.HUMAN_FORM.get()), entity.m_9236_());
            humanFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            humanFormEntity.setVariant(deadHumanFormEntity.getVariant());
            humanFormEntity.m_5618_(((DeadHumanFormEntity)entity).f_20883_);
            humanFormEntity.m_5616_(((DeadHumanFormEntity)entity).f_20885_);
            humanFormEntity.setIsReanimated(true);
            humanFormEntity.setTransformed(true);
            this.registerExtra(humanFormEntity, (Entity)deadHumanFormEntity);
            entity.m_9236_().m_7967_((Entity)humanFormEntity);
        } else if (entity instanceof DeadPlayerFormEntity) {
            DeadPlayerFormEntity deadPlayerFormEntity = (DeadPlayerFormEntity)entity;
            PlayerFormEntity playerFormEntity = new PlayerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.PLAYER_FORM.get()), entity.m_9236_());
            playerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            playerFormEntity.setVariant(deadPlayerFormEntity.getVariant());
            playerFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadPlayerFormEntity.m_21205_());
            playerFormEntity.m_5618_(((DeadPlayerFormEntity)entity).f_20883_);
            playerFormEntity.m_5616_(((DeadPlayerFormEntity)entity).f_20885_);
            playerFormEntity.setIsReanimated(true);
            playerFormEntity.setTransformed(true);
            this.registerExtra(playerFormEntity, (Entity)deadPlayerFormEntity);
            entity.m_9236_().m_7967_((Entity)playerFormEntity);
        } else if (entity instanceof DeadVillagerFormEntity) {
            DeadVillagerFormEntity deadVillagerFormEntity = (DeadVillagerFormEntity)entity;
            VillagerFormEntity villagerFormEntity = new VillagerFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.VILLAGER_FORM.get()), entity.m_9236_());
            villagerFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            villagerFormEntity.setVariant(deadVillagerFormEntity.getVariant());
            villagerFormEntity.m_5618_(((DeadVillagerFormEntity)entity).f_20883_);
            villagerFormEntity.m_5616_(((DeadVillagerFormEntity)entity).f_20885_);
            villagerFormEntity.setIsReanimated(true);
            villagerFormEntity.setTransformed(true);
            this.registerExtra(villagerFormEntity, (Entity)deadVillagerFormEntity);
            entity.m_9236_().m_7967_((Entity)villagerFormEntity);
        } else if (entity instanceof DeadSangheiliFormEntity) {
            DeadSangheiliFormEntity deadSangheiliFormEntity = (DeadSangheiliFormEntity)entity;
            SangheiliFormEntity sangheiliFormEntity = new SangheiliFormEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.SANGHEILI_FORM.get()), entity.m_9236_());
            sangheiliFormEntity.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            sangheiliFormEntity.setVariant(deadSangheiliFormEntity.getVariant());
            sangheiliFormEntity.setTextureVariant(deadSangheiliFormEntity.getTextureVariant());
            sangheiliFormEntity.setGunVariant(deadSangheiliFormEntity.getGunVariant());
            sangheiliFormEntity.m_8061_(EquipmentSlot.MAINHAND, deadSangheiliFormEntity.m_21205_());
            sangheiliFormEntity.setAmmo(deadSangheiliFormEntity.getAmmo());
            sangheiliFormEntity.m_5618_(((DeadSangheiliFormEntity)entity).f_20883_);
            sangheiliFormEntity.m_5616_(((DeadSangheiliFormEntity)entity).f_20885_);
            sangheiliFormEntity.setIsReanimated(true);
            sangheiliFormEntity.setTransformed(true);
            this.registerExtra(sangheiliFormEntity, (Entity)deadSangheiliFormEntity);
            entity.m_9236_().m_7967_((Entity)sangheiliFormEntity);
        }
    }

    private void registerExtra(BaseForm baseForm, Entity entity) {
        baseForm.m_146926_(entity.m_146909_());
        baseForm.m_146922_(entity.m_146908_());
        baseForm.m_21153_(baseForm.m_21233_() / 2.0f);
        baseForm.m_21563_().m_24964_(entity.m_20154_());
        baseForm.m_6593_(entity.m_7770_());
    }

    private void generateParticles(Level level, Entity entity, RandomSource random) {
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), entity.m_20208_(0.5), entity.m_20187_() + 0.35, entity.m_20262_(0.65), 35, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)random));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, entity.m_20208_(0.25), entity.m_20187_() + 0.25, entity.m_20262_(0.25), 5, 0.1, 0.2, 0.1, 0.01);
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), entity.m_20208_(0.25), entity.m_20187_() + 0.25, entity.m_20262_(0.25), 70, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)random));
        }
    }

    private void playReanimationSound(Level level, Entity entity) {
        level.m_5594_(null, entity.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
    }

    @Nullable
    private PathfinderMob getFreePartner() {
        List list = this.level.m_45971_(this.partnerClass, PARTNER_TARGETING, (LivingEntity)this.mob, this.mob.m_20191_().m_82400_(this.mob.m_21172_(Attributes.f_22277_)));
        double d0 = Double.MAX_VALUE;
        PathfinderMob inf = null;
        for (PathfinderMob inf1 : list) {
            if (!(this.mob.m_20280_((Entity)inf1) < d0)) continue;
            inf = inf1;
            d0 = this.mob.m_20280_((Entity)inf1);
        }
        return inf;
    }
}

