/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.categories;

import net.asestefan.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.registry.BlockRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;

public class BodyEntity
extends Monster {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DESPAWN_TICKS = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TAKEN = SynchedEntityData.m_135353_(BodyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected BodyEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 0;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(DESPAWN_TICKS, (Object)0);
        this.f_19804_.m_135372_(TAKEN, (Object)false);
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant());
        compoundTag.m_128405_("Despawn_Ticks", this.getDespawnTicks());
        compoundTag.m_128379_("Taken", this.isTaken());
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setVariant(compoundTag.m_128451_("Variant"));
        this.setDespawnTicks(compoundTag.m_128451_("Despawn_Ticks"));
        this.setTaken(compoundTag.m_128471_("Taken"));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getDespawnTicks() {
        return (Integer)this.f_19804_.m_135370_(DESPAWN_TICKS);
    }

    public void setDespawnTicks(int ticks) {
        this.f_19804_.m_135381_(DESPAWN_TICKS, (Object)ticks);
    }

    public boolean isTaken() {
        return (Boolean)this.f_19804_.m_135370_(TAKEN);
    }

    public void setTaken(boolean value) {
        this.f_19804_.m_135381_(TAKEN, (Object)value);
    }

    public void m_8119_() {
        super.m_8119_();
        this.setDespawnTicks(this.getDespawnTicks() + 1);
        if (this.getDespawnTicks() == 12000) {
            this.m_146870_();
            this.vanish();
        }
    }

    private void vanish() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            world.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), 35, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            world.m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 5, 0.1, 0.2, 0.1, 0.01);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12609_, SoundSource.HOSTILE, 1.25f, 0.95f);
        AABB aabb = this.m_20191_().m_82400_(1.0);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockState = this.m_9236_().m_8055_(blockpos);
            BlockState above = this.m_9236_().m_8055_(blockpos.m_7494_());
            BlockState east = this.m_9236_().m_8055_(blockpos.m_122029_());
            BlockState west = this.m_9236_().m_8055_(blockpos.m_122024_());
            if (this.m_9236_().m_5776_() || !blockState.m_60804_((BlockGetter)this.m_9236_(), blockpos) || !above.m_60795_() || !(Math.random() < 0.9)) continue;
            if (Math.random() < 0.25) {
                this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                if (Math.random() <= 0.25 && west.m_60795_()) {
                    this.m_9236_().m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                }
                if (!(Math.random() <= 0.35) || !east.m_60795_()) continue;
                this.m_9236_().m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                continue;
            }
            if (!(Math.random() < 0.15)) continue;
            this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
            if (Math.random() <= 0.25 && east.m_60795_()) {
                this.m_9236_().m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
            }
            if (!(Math.random() <= 0.35) || !west.m_60795_()) continue;
            this.m_9236_().m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.m_146870_();
        this.vanish();
        super.m_6667_(pDamageSource);
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        if (pHand == InteractionHand.MAIN_HAND && (pPlayer.m_21205_().m_41720_() == Items.f_42409_ || pPlayer.m_21205_().m_41720_() == Items.f_42448_)) {
            this.m_146870_();
            this.vanish();
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_276093_(DamageTypes.f_268546_) || pSource.m_276093_(DamageTypes.f_268468_) || pSource.m_276093_(DamageTypes.f_268631_)) {
            return super.m_6469_(pSource, pAmount);
        }
        return false;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return null;
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return pDistanceToClosestPlayer > 16384.0;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

