/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import java.util.List;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.ParticleUtils;
import net.asestefan.utils.SoundUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Squid;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.teamabyssalofficial.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.ai.CustomMeleeAttackGoal;
import net.teamabyssalofficial.entity.ai.FastSwimmingDiveGoal;
import net.teamabyssalofficial.entity.categories.BaseForm;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.registry.BlockRegistry;
import net.teamabyssalofficial.registry.DamageTypeRegistry;
import net.teamabyssalofficial.registry.EffectRegistry;
import net.teamabyssalofficial.registry.EntityRegistry;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import net.teamabyssalofficial.util.WorldDataUtils;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CarrierFormEntity
extends Monster
implements GeoEntity,
SoundUtils {
    private static final EntityDataAccessor<Integer> AGGRO_TICKS = SynchedEntityData.m_135353_(CarrierFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> SIZE_VARIANT = SynchedEntityData.m_135353_(CarrierFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EXPLOSION_TIMER = SynchedEntityData.m_135353_(CarrierFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final int SIZE0 = 0;
    public static final int SIZE1 = 1;
    public static final int SIZE2 = 2;
    public static final int SIZE3 = 3;
    public static final int SIZE4 = 4;
    public static final int EXPLOSION_ANIM_TIMER = 21;
    public final double noSpeed = 0.0;
    private boolean isClose = false;
    public int podCount = 3;

    public CarrierFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 32.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -3.2f);
        this.m_274367_(0.5f);
        this.f_21364_ = 0;
        EntityRegistry.FLOOD_FORMS.add((Entity)this);
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SIZE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(EXPLOSION_TIMER, (Object)0);
        this.f_19804_.m_135372_(AGGRO_TICKS, (Object)0);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("sizeVariant", this.getSizeVariant());
        nbt.m_128405_("explosionTimer", this.getExplosionTimer());
        nbt.m_128405_("aggroTicks", this.getAggroTicks());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setSizeVariant(nbt.m_128451_("sizeVariant"));
        this.setExplosionTimer(nbt.m_128451_("explosionTimer"));
        this.setAggroTicks(nbt.m_128451_("aggroTicks"));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22276_, ((Double)DawnOfTheFloodConfig.SERVER.carrier_form_health.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)DawnOfTheFloodConfig.SERVER.carrier_form_damage.get()).doubleValue()).m_22268_(Attributes.f_22282_, 0.15).m_22268_(Attributes.f_22278_, 0.35).m_22268_(Attributes.f_22284_, 5.0);
    }

    public int m_20146_() {
        return super.m_6062_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new CustomMeleeAttackGoal((PathfinderMob)this, 1.2, false){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return 1.8 + (double)(entity.m_20205_() * entity.m_20205_());
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FastSwimmingDiveGoal((Mob)this){

            @Override
            public boolean m_8036_() {
                ServerLevel world;
                Level level;
                return super.m_8036_() && (level = CarrierFormEntity.this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() >= 3;
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FloatGoal((Mob)this){

            public boolean m_8036_() {
                ServerLevel world;
                Level level;
                return super.m_8036_() && (level = CarrierFormEntity.this.m_9236_()) instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() < 3;
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8){

            public boolean m_8036_() {
                return super.m_8036_() && this.f_25725_.m_5448_() == null;
            }

            public boolean m_8045_() {
                return super.m_8045_() && this.f_25725_.m_5448_() == null;
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, this::targetPredicate));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{BaseForm.class}));
    }

    private boolean targetPredicate(LivingEntity liv) {
        return !EntityRegistry.FLOOD_FORMS.contains(liv) && !(liv instanceof Squid) && !(liv instanceof ArmorStand) && !(liv instanceof AbstractFish) && !(liv instanceof Bat) && !((List)DawnOfTheFloodConfig.SERVER.blacklist.get()).contains(liv.m_20078_());
    }

    public static boolean checkCarrierFormRules(EntityType<? extends CarrierFormEntity> entityType, ServerLevelAccessor levelAccessor, MobSpawnType mobSpawnType, BlockPos pos, RandomSource source) {
        WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(levelAccessor.m_6018_());
        int currentWave = worldDataUtils.getWave();
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && CarrierFormEntity.m_219009_((ServerLevelAccessor)levelAccessor, (BlockPos)pos, (RandomSource)source) && CarrierFormEntity.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)mobSpawnType, (BlockPos)pos, (RandomSource)source) && currentWave > 2;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (this.getExplosionTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("carrier.form.explode2"));
            }
            if (!event.isMoving() && !this.m_5912_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("carrier.form.idle"));
            }
            if (event.isMoving() && !this.m_5912_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("carrier.form.walk"));
            }
            if (event.isMoving() && this.m_5912_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("carrier.form.target"));
            }
            return PlayState.CONTINUE;
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public int getSizeVariant() {
        return (Integer)this.f_19804_.m_135370_(SIZE_VARIANT);
    }

    public void setSizeVariant(int variant) {
        this.f_19804_.m_135381_(SIZE_VARIANT, (Object)variant);
    }

    public int getExplosionTimer() {
        return (Integer)this.f_19804_.m_135370_(EXPLOSION_TIMER);
    }

    public void setExplosionTimer(int ticks) {
        this.f_19804_.m_135381_(EXPLOSION_TIMER, (Object)ticks);
    }

    public int getAggroTicks() {
        return (Integer)this.f_19804_.m_135370_(AGGRO_TICKS);
    }

    public void setAggroTicks(int ticks) {
        this.f_19804_.m_135381_(AGGRO_TICKS, (Object)ticks);
    }

    public float getVolume() {
        return 1.85f;
    }

    public float getPitch(RandomSource random) {
        return 0.75f;
    }

    protected SoundEvent m_7975_(DamageSource p_33034_) {
        return (SoundEvent)SoundRegistry.CARRIER_FORM_HURT.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pState) {
        super.m_7355_(pPos, pState);
        this.m_5496_((SoundEvent)SoundRegistry.CARRIER_FORM_STEP.get(), this.getVolume() / 2.0f, this.getPitch(this.f_19796_) + 0.25f);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.POD_INFECTOR_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.POD_INFECTOR_IDLE.get();
    }

    public float m_6100_() {
        return this.getPitch(this.f_19796_);
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(1.5f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(6);
        cloud.m_19734_(Mth.m_14107_((double)((double)cloud.m_19748_() / 3.0 * 1.2)));
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 200, 0));
        cloud.m_19716_(new MobEffectInstance((MobEffect)EffectRegistry.PLAGUE_OF_THE_FLOOD.get(), 2500, 0));
        this.m_9236_().m_7967_((Entity)cloud);
    }

    private void vanish() {
        if (!this.m_9236_().f_46443_) {
            this.f_20890_ = true;
            this.m_146870_();
        }
    }

    private void burst() {
        AABB boundingBox = this.m_20191_().m_82400_(6.5);
        List entities = this.m_9236_().m_45933_((Entity)this, boundingBox);
        for (Entity entity : entities) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || EntityRegistry.FLOOD_FORMS.contains(livingEntity = (LivingEntity)entity)) continue;
            livingEntity.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 200, 0), (Entity)livingEntity);
            livingEntity.m_147207_(new MobEffectInstance((MobEffect)EffectRegistry.PLAGUE_OF_THE_FLOOD.get(), 2500, 0), (Entity)livingEntity);
            livingEntity.f_20883_ = livingEntity.f_20885_;
            float dist = this.m_20270_((Entity)livingEntity);
            float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f)) * 5.0f;
            float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f)) * 5.0f;
            livingEntity.m_5997_((double)(f1 * this.f_19796_.m_188501_()) * 4.0 * (double)(1.0f / dist), 1.5 * (double)this.f_19796_.m_188501_(), (double)(f2 * this.f_19796_.m_188501_()) * 4.0 * (double)(1.0f / dist));
            livingEntity.m_6469_(DamageTypeRegistry.form_exploded_damage((LivingEntity)this), (float)(3.1415927410125732 * Math.pow(1.5, 1.5) * (double)((Double)DawnOfTheFloodConfig.SERVER.carrier_form_explosion_damage.get()).floatValue() * (double)(1.0f / dist)));
            AABB aabb = this.m_20191_().m_82400_(1.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                BlockState blockState = this.m_9236_().m_8055_(blockpos);
                BlockState above = this.m_9236_().m_8055_(blockpos.m_7494_());
                BlockState east = this.m_9236_().m_8055_(blockpos.m_122029_());
                BlockState west = this.m_9236_().m_8055_(blockpos.m_122024_());
                if (this.m_9236_().m_5776_() || !blockState.m_60804_((BlockGetter)this.m_9236_(), blockpos) || !above.m_60795_() || !(Math.random() < 0.9)) continue;
                if (Math.random() < 0.25) {
                    this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    if (Math.random() <= 0.25 && west.m_60795_()) {
                        this.m_9236_().m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    }
                    if (!(Math.random() <= 0.35) || !east.m_60795_()) continue;
                    this.m_9236_().m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH2.get()).m_49966_(), 3);
                    continue;
                }
                if (!(Math.random() < 0.15)) continue;
                this.m_9236_().m_7731_(blockpos.m_7494_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                if (Math.random() <= 0.25 && east.m_60795_()) {
                    this.m_9236_().m_7731_(blockpos.m_122029_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
                }
                if (!(Math.random() <= 0.35) || !west.m_60795_()) continue;
                this.m_9236_().m_7731_(blockpos.m_122024_(), ((Block)BlockRegistry.FLOOD_BLOOD_SPLASH1.get()).m_49966_(), 3);
            }
        }
        if (((Boolean)DawnOfTheFloodConfig.SERVER.carrier_form_screen_shake.get()).booleanValue()) {
            ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)16.0f, (float)0.25f, (int)8, (int)5);
        }
        this.spawnLingeringCloud();
        this.vanish();
        for (int i = 0; i < this.podCount; ++i) {
            this.spawnPods((Entity)this);
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 85, 0.2, 0.8, 0.4, 0.15);
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.GUTS.get()), this.m_20208_(0.5), this.m_20187_() + 0.35, this.m_20262_(0.65), 35, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
            server.m_8767_((ParticleOptions)ParticleTypes.f_123747_, this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 9, 0.1, 0.2, 0.1, 0.01);
        }
        this.m_9236_().m_5594_((Player)null, this.m_20183_(), (SoundEvent)SoundRegistry.CARRIER_FORM_EXPLOSION.get(), SoundSource.HOSTILE, this.getVolume(), this.getPitch(this.f_19796_));
    }

    public int getSubtractionPoints() {
        return 30;
    }

    public void m_6667_(DamageSource source) {
        this.burst();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
            int currentScore = worldDataUtils.getScore();
            int currentWave = worldDataUtils.getWave();
            if (currentWave > 2) {
                worldDataUtils.setScore(currentScore - this.getSubtractionPoints());
            }
        }
        super.m_6667_(source);
    }

    protected void m_8024_() {
        if (this.getExplosionTimer() > 0) {
            this.setExplosionTimer(this.getExplosionTimer() - 1);
        }
        super.m_8024_();
    }

    public void m_8119_() {
        float dist;
        super.m_8119_();
        if (this.m_5448_() != null && ((Boolean)DawnOfTheFloodConfig.SERVER.carrier_form_aggro_despawn.get()).booleanValue()) {
            this.setAggroTicks(this.getAggroTicks() + 1);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21195_(MobEffects.f_19614_);
        }
        if (this.m_5448_() != null && (dist = this.m_20270_((Entity)this.m_5448_())) <= 2.2f && !this.isClose) {
            this.setExplosionTimer(21);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            this.isClose = true;
        }
        if (this.m_21223_() <= this.m_21233_() / 2.0f && !this.isClose && this.getExplosionTimer() == 0) {
            this.setExplosionTimer(21);
            this.m_21051_(Attributes.f_22279_).m_22100_(0.0);
            this.isClose = true;
        }
        if (this.getExplosionTimer() == 1) {
            this.burst();
        }
        if (this.getExplosionTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.canRegenerate() && ((Boolean)DawnOfTheFloodConfig.SERVER.carrier_form_regeneration.get()).booleanValue() && this.m_217043_().m_188503_(300) == 0 && (double)this.m_21223_() < (double)this.m_21233_() - 1.0) {
            this.m_5634_(1.0f);
        }
    }

    public boolean canRegenerate() {
        return !this.m_6060_();
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 3, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    private void spawnPods(Entity entity) {
        PodInfectorEntity[] podInfectorEntity = new PodInfectorEntity[]{new PodInfectorEntity((EntityType<? extends Monster>)((EntityType)EntityRegistry.POD_INFECTOR.get()), entity.m_9236_())};
        for (int i = 0; i < 1; ++i) {
            podInfectorEntity[i].m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            entity.m_9236_().m_7967_((Entity)podInfectorEntity[i]);
            podInfectorEntity[i].m_20254_(entity.m_20094_());
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return this.getAggroTicks() < (Integer)DawnOfTheFloodConfig.SERVER.carrier_form_aggro_ticks.get();
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @javax.annotation.Nullable SpawnGroupData spawnGroupData, @javax.annotation.Nullable CompoundTag compoundTag) {
        int rand = this.f_19796_.m_188503_(5);
        switch (rand) {
            case 0: {
                this.setSizeVariant(0);
                break;
            }
            case 1: {
                this.setSizeVariant(1);
                break;
            }
            case 2: {
                this.setSizeVariant(2);
                break;
            }
            case 3: {
                this.setSizeVariant(3);
                break;
            }
            case 4: {
                this.setSizeVariant(4);
            }
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, spawnGroupData, compoundTag);
    }

    static class Variants {
        public static final int SIZE0 = 0;
        public static final int SIZE1 = 1;
        public static final int SIZE2 = 2;
        public static final int SIZE3 = 3;
        public static final int SIZE4 = 4;

        Variants() {
        }
    }
}

