/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.entity.custom;

import net.asestefan.screenshake.ScreenShakeUtils;
import net.asestefan.utils.ParticleUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.teamabyssalofficial.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.categories.BodyEntity;
import net.teamabyssalofficial.registry.ParticleRegistry;
import net.teamabyssalofficial.registry.SoundRegistry;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DeadPlayerFormEntity
extends BodyEntity
implements GeoEntity {
    private static final EntityDataAccessor<Integer> FALL_TIMER = SynchedEntityData.m_135353_(DeadPlayerFormEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final int FALL_ANIMATION_TICK = 23;

    public DeadPlayerFormEntity(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    @Override
    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FALL_TIMER, (Object)23);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Fall_Timer", this.getFallTimer());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setFallTimer(compoundTag.m_128451_("Fall_Timer"));
    }

    public int getFallTimer() {
        return (Integer)this.f_19804_.m_135370_(FALL_TIMER);
    }

    public void setFallTimer(int ticks) {
        this.f_19804_.m_135381_(FALL_TIMER, (Object)ticks);
    }

    protected void m_8024_() {
        if (this.getFallTimer() > 0) {
            this.setFallTimer(this.getFallTimer() - 1);
        }
        super.m_8024_();
    }

    private void summonFloodParticle() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)((SimpleParticleType)ParticleRegistry.FLOOD_BLOOD_SPLASH.get()), this.m_20208_(0.25), this.m_20187_() + 0.25, this.m_20262_(0.25), 2, 0.1, 0.2, 0.1, ParticleUtils.getDownwardsSmallSpread((RandomSource)this.f_19796_));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.getFallTimer() > 0) {
            this.summonFloodParticle();
        }
        if (this.getFallTimer() == 5) {
            if (((Boolean)DawnOfTheFloodConfig.SERVER.corpse_screen_shake_ground.get()).booleanValue()) {
                ScreenShakeUtils.ScreenShake((Level)this.m_9236_(), (Vec3)this.m_20182_(), (float)8.0f, (float)0.15f, (int)5, (int)2);
            }
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)SoundRegistry.BODY_FALL.get(), SoundSource.HOSTILE, 1.05f, 0.95f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerV) {
        controllerV.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller1", 7, event -> {
            if (this.getFallTimer() > 0) {
                return event.setAndContinue(RawAnimation.begin().thenPlayAndHold("dead.player.form.fall"));
            }
            if (((Boolean)DawnOfTheFloodConfig.SERVER.corpse_head_shake_animation.get()).booleanValue()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("dead.player.form.idle"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("dead.player.form.idle.noshake"));
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

