/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.event.extra;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.teamabyssalofficial.util.WorldDataUtils;

@Mod.EventBusSubscriber(modid="dotf")
public class PlayerPhaseEvent {
    @SubscribeEvent
    public static void PhaseEvent(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase == TickEvent.Phase.END && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player = event.player.m_9236_();
            if (player instanceof ServerLevel) {
                ServerLevel world = (ServerLevel)player;
                WorldDataUtils worldDataUtils = WorldDataUtils.getWorldDataRegistry(world);
                worldDataUtils.waveHandlerEvent(world, player2);
            }
        }
    }

    @SubscribeEvent
    public static void PointIncrementEvent(TickEvent.LevelTickEvent event) {
        Level level;
        if (event.phase == TickEvent.Phase.END && (level = event.level) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            WorldDataUtils worldDataRegistry = WorldDataUtils.getWorldDataRegistry(world);
            int currentWave = worldDataRegistry.getWave();
            int currentScore = worldDataRegistry.getScore();
            int main_score = 5;
            if (event.level.m_46791_() == Difficulty.EASY) {
                if (Math.random() < (double)0.8f) {
                    switch (currentWave) {
                        case 0: {
                            main_score = 1;
                            break;
                        }
                        case 1: {
                            main_score = 2;
                            break;
                        }
                        case 2: {
                            main_score = 4;
                            break;
                        }
                        case 3: {
                            main_score = 13;
                            break;
                        }
                        case 4: {
                            main_score = 23;
                            break;
                        }
                        case 5: {
                            main_score = 49;
                        }
                    }
                } else if (Math.random() < (double)0.2f) {
                    switch (currentWave) {
                        case 0: {
                            main_score = 2;
                            break;
                        }
                        case 1: {
                            main_score = 3;
                            break;
                        }
                        case 2: {
                            main_score = 7;
                            break;
                        }
                        case 3: {
                            main_score = 16;
                            break;
                        }
                        case 4: {
                            main_score = 32;
                            break;
                        }
                        case 5: {
                            main_score = 57;
                        }
                    }
                }
            } else if (event.level.m_46791_() == Difficulty.NORMAL) {
                if (Math.random() < (double)0.8f) {
                    switch (currentWave) {
                        case 0: {
                            main_score = 2;
                            break;
                        }
                        case 1: {
                            main_score = 3;
                            break;
                        }
                        case 2: {
                            main_score = 7;
                            break;
                        }
                        case 3: {
                            main_score = 16;
                            break;
                        }
                        case 4: {
                            main_score = 32;
                            break;
                        }
                        case 5: {
                            main_score = 61;
                        }
                    }
                } else if (Math.random() < (double)0.2f) {
                    switch (currentWave) {
                        case 0: {
                            main_score = 2;
                            break;
                        }
                        case 1: {
                            main_score = 4;
                            break;
                        }
                        case 2: {
                            main_score = 9;
                            break;
                        }
                        case 3: {
                            main_score = 18;
                            break;
                        }
                        case 4: {
                            main_score = 38;
                            break;
                        }
                        case 5: {
                            main_score = 72;
                        }
                    }
                }
            } else if (event.level.m_46791_() == Difficulty.HARD) {
                if (Math.random() < (double)0.8f) {
                    switch (currentWave) {
                        case 0: {
                            main_score = 3;
                            break;
                        }
                        case 1: {
                            main_score = 6;
                            break;
                        }
                        case 2: {
                            main_score = 11;
                            break;
                        }
                        case 3: {
                            main_score = 24;
                            break;
                        }
                        case 4: {
                            main_score = 42;
                            break;
                        }
                        case 5: {
                            main_score = 81;
                        }
                    }
                } else if (Math.random() < (double)0.2f) {
                    switch (currentWave) {
                        case 0: {
                            main_score = 3;
                            break;
                        }
                        case 1: {
                            main_score = 7;
                            break;
                        }
                        case 2: {
                            main_score = 14;
                            break;
                        }
                        case 3: {
                            main_score = 32;
                            break;
                        }
                        case 4: {
                            main_score = 51;
                            break;
                        }
                        case 5: {
                            main_score = 93;
                        }
                    }
                }
            }
            if (Math.random() <= (double)0.01993f) {
                worldDataRegistry.setScore(currentScore + main_score);
            }
        }
    }

    @SubscribeEvent
    public static void SleepEvent(PlayerSleepInBedEvent event) {
        Player player;
        if (event.getEntity() != null && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            WorldDataUtils worldDataRegistry = WorldDataUtils.getWorldDataRegistry((ServerLevel)player2.m_9236_());
            int currentWave = worldDataRegistry.getWave();
            int currentScore = worldDataRegistry.getScore();
            switch (currentWave) {
                case 0: {
                    worldDataRegistry.setScore(currentScore + 60);
                    worldDataRegistry.m_77762_();
                    break;
                }
                case 1: {
                    worldDataRegistry.setScore(currentScore + 120);
                    worldDataRegistry.m_77762_();
                    break;
                }
                case 2: {
                    worldDataRegistry.setScore(currentScore + 240);
                    worldDataRegistry.m_77762_();
                    break;
                }
                case 3: {
                    worldDataRegistry.setScore(currentScore + 480);
                    worldDataRegistry.m_77762_();
                    break;
                }
                case 4: {
                    worldDataRegistry.setScore(currentScore + 960);
                    worldDataRegistry.m_77762_();
                    break;
                }
                case 5: {
                    worldDataRegistry.setScore(currentScore + 1920);
                    worldDataRegistry.m_77762_();
                }
            }
        }
    }
}

