/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.teamabyssalofficial.guns.client.model.GunModel;
import net.teamabyssalofficial.guns.gun.GunItem;
import net.teamabyssalofficial.guns.helper.GunModifierHelper;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.util.RenderUtils;

public class GunRenderer
extends GeoItemRenderer<GunItem>
implements GeoRenderer<GunItem> {
    private MultiBufferSource bufferIn;
    private ItemDisplayContext renderType;
    GunItem golem;
    ResourceLocation text;

    public GunRenderer(ResourceLocation identifier) {
        super((GeoModel)new GunModel(identifier));
    }

    protected void renderInGui(ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.renderInGui(transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    public void preRender(PoseStack poseStack, GunItem animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.golem = animatable;
        this.bufferIn = bufferSource;
        this.text = this.getTextureLocation((Item)animatable);
        super.preRender(poseStack, (Item)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_108829_(ItemStack stack, ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        this.bufferIn = bufferSource;
        this.renderType = transformType;
        super.m_108829_(stack, transformType, poseStack, bufferSource, packedLight, packedOverlay);
    }

    public void renderRecursively(PoseStack poseStack, GunItem animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderRecursively(poseStack, (Item)animatable, bone, renderType, this.bufferIn, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        Minecraft client = Minecraft.m_91087_();
        boolean renderArms = false;
        if (animatable.getGunProperties() == GunItem.GunProperties.NEEDLER && client.f_91074_ != null && bone.getName().equals("GunBody")) {
            float scale = 0.75f;
            bone.setScaleX(scale);
            bone.setScaleY(scale);
            bone.setScaleZ(scale);
        }
        if (this.renderType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
            if (animatable.getGunProperties() == GunItem.GunProperties.NEEDLER && client.f_91074_ != null) {
                CompoundTag itemTag = this.getCurrentItemStack().m_41784_();
                for (int i = 0; i <= 13; ++i) {
                    if (!bone.getName().equals("Spike" + i)) continue;
                    bone.setHidden(itemTag.m_128451_("Clip") < i);
                }
            }
            poseStack.m_85836_();
            switch (bone.getName()) {
                case "leftArm": 
                case "rightArm": {
                    bone.setHidden(true);
                    bone.setChildrenHidden(false);
                    renderArms = true;
                    break;
                }
                case "muzzleflash": {
                    bone.setHidden(true);
                    String reloadKey = "isReloading";
                    String aimKey = "isAiming";
                    String inspectKey = "isInspecting";
                    if (!KeybindHelper.getShootMapping().m_90857_() || this.getCurrentItemStack().m_41784_().m_128471_(inspectKey) || this.getCurrentItemStack().m_41784_().m_128471_(reloadKey) || client.f_91074_ == null || client.f_91074_.m_20142_() || !GunItem.isLoaded(this.getCurrentItemStack())) break;
                    RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
                    int PI = 180;
                    float slerp = switch (animatable.getMuzzleVariant()) {
                        case 2 -> animatable.random.nextInt(PI / 32);
                        default -> animatable.random.nextInt(PI / 16);
                    };
                    if (animatable.getGunProperties() == GunItem.GunProperties.NORMAL) {
                        if (!this.getCurrentItemStack().m_41784_().m_128471_(aimKey)) {
                            poseStack.m_252781_(new Quaternionf().rotateZ(slerp / 8.0f));
                        } else {
                            poseStack.m_252781_(new Quaternionf().rotateZ(slerp / 16.0f));
                        }
                    } else if (!this.getCurrentItemStack().m_41784_().m_128471_(aimKey)) {
                        poseStack.m_252781_(new Quaternionf().rotateZ(slerp / 16.0f));
                    } else {
                        poseStack.m_252781_(new Quaternionf().rotateZ(slerp / 8.0f));
                    }
                    if (this.getCurrentItemStack().m_41784_().m_128471_(aimKey)) {
                        scaleModifier = animatable.getMuzzleFlashSizeAim();
                        poseStack.m_85841_(scaleModifier, scaleModifier, scaleModifier);
                        switch (animatable.getMuzzleVariant()) {
                            case 0: {
                                poseStack.m_85837_((double)bone.getPivotX() - 0.62, (double)bone.getPivotY() - 1.035, (double)bone.getPivotZ() + 0.331);
                                break;
                            }
                            case 1: {
                                poseStack.m_85837_((double)bone.getPivotX() - 0.659, (double)bone.getPivotY() - 1.781, (double)bone.getPivotZ() + 2.256);
                                break;
                            }
                            case 2: {
                                poseStack.m_85837_((double)bone.getPivotX() - 0.389, (double)bone.getPivotY() - 5.853, (double)bone.getPivotZ() + 8.134);
                            }
                        }
                    } else {
                        scaleModifier = animatable.getMuzzleFlashSizeNormal();
                        poseStack.m_85841_(scaleModifier, scaleModifier, scaleModifier);
                        switch (animatable.getMuzzleVariant()) {
                            case 0: {
                                poseStack.m_85837_((double)bone.getPivotX() - 0.283, (double)bone.getPivotY() - 1.643, (double)bone.getPivotZ() + 1.034);
                                break;
                            }
                            case 1: {
                                poseStack.m_85837_((double)bone.getPivotX() - 0.461, (double)bone.getPivotY() - 2.077, (double)bone.getPivotZ() + 3.283);
                                break;
                            }
                            case 2: {
                                poseStack.m_85837_((double)bone.getPivotX() - 0.225, (double)bone.getPivotY() - 6.336, (double)bone.getPivotZ() + 8.474);
                            }
                        }
                    }
                    float minU = GunModifierHelper.getMuzzleMin();
                    float maxU = GunModifierHelper.getMuzzleMax();
                    Matrix4f matrix = poseStack.m_85850_().m_252922_();
                    RenderType muzzleType = animatable.getMuzzleFlashType();
                    VertexConsumer builder = this.bufferIn.m_6299_(muzzleType);
                    builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU * 2.0f, -1.0f).m_85969_(0xF000F0).m_5752_();
                    builder.m_252986_(matrix, 1.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, -1.0f).m_85969_(0xF000F0).m_5752_();
                    builder.m_252986_(matrix, 1.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, 0.0f).m_85969_(0xF000F0).m_5752_();
                    builder.m_252986_(matrix, 0.0f, 1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(maxU * 2.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
                    Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(muzzleType);
                }
            }
            if (renderArms) {
                assert (client.f_91074_ != null);
                PlayerRenderer playerEntityRenderer = (PlayerRenderer)client.m_91290_().m_114382_((Entity)client.f_91074_);
                PlayerModel playerEntityModel = (PlayerModel)playerEntityRenderer.m_7200_();
                RenderUtils.translateMatrixToBone((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.translateToPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.rotateMatrixAroundBone((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.scaleMatrixForBone((PoseStack)poseStack, (CoreGeoBone)bone);
                RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (CoreGeoBone)bone);
                ResourceLocation playerSkin = client.f_91074_.m_108560_();
                VertexConsumer arm = this.bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)playerSkin));
                VertexConsumer sleeve = this.bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)playerSkin));
                if (bone.getName().equals("leftArm")) {
                    poseStack.m_85841_(0.67f, 1.33f, 0.67f);
                    poseStack.m_85837_(-0.25, -0.43625, 0.1625);
                    playerEntityModel.f_102812_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_102812_.f_104203_ = 0.0f;
                    playerEntityModel.f_102812_.f_104204_ = 0.0f;
                    playerEntityModel.f_102812_.f_104205_ = 0.0f;
                    playerEntityModel.f_102812_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    playerEntityModel.f_103374_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_103374_.f_104203_ = 0.0f;
                    playerEntityModel.f_103374_.f_104204_ = 0.0f;
                    playerEntityModel.f_103374_.f_104205_ = 0.0f;
                    playerEntityModel.f_103374_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                } else if (bone.getName().equals("rightArm")) {
                    poseStack.m_85841_(0.67f, 1.33f, 0.67f);
                    poseStack.m_85837_(0.25, -0.43625, 0.1625);
                    playerEntityModel.f_102811_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_102811_.f_104203_ = 0.0f;
                    playerEntityModel.f_102811_.f_104204_ = 0.0f;
                    playerEntityModel.f_102811_.f_104205_ = 0.0f;
                    playerEntityModel.f_102811_.m_104306_(poseStack, arm, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                    playerEntityModel.f_103375_.m_104227_(bone.getPivotX(), bone.getPivotY(), bone.getPivotZ());
                    playerEntityModel.f_103375_.f_104203_ = 0.0f;
                    playerEntityModel.f_103375_.f_104204_ = 0.0f;
                    playerEntityModel.f_103375_.f_104205_ = 0.0f;
                    playerEntityModel.f_103375_.m_104306_(poseStack, sleeve, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        } else {
            poseStack.m_85836_();
            switch (bone.getName()) {
                case "leftArm": 
                case "rightArm": {
                    bone.setHidden(true);
                    bone.setChildrenHidden(false);
                }
            }
        }
        poseStack.m_85849_();
        buffer = this.bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)this.text));
    }
}

