/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.guns.gun;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.asestefan.screenshake.ScreenShakeUtils;
import net.fabridge.fabricmc.network.ClientPlayNetworking;
import net.fabridge.fabricmc.network.ServerPlayNetworking;
import net.fabridge.fabricmc.network.fabric.PacketByteBufs;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.extensions.IForgeItem;
import net.minecraftforge.registries.RegistryObject;
import net.teamabyssalofficial.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.dotf.DawnOfTheFlood;
import net.teamabyssalofficial.guns.animations.GunAnimations;
import net.teamabyssalofficial.guns.bullet.BulletProjectileEntity;
import net.teamabyssalofficial.guns.client.renderer.GunRenderer;
import net.teamabyssalofficial.guns.helper.GunInventoryHelper;
import net.teamabyssalofficial.guns.helper.KeybindHelper;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtils;

public abstract class GunItem
extends ProjectileWeaponItem
implements IForgeItem,
GeoAnimatable,
GeoItem {
    public final Random random;
    private final String gunID;
    private final String animationID;
    private final float bulletDamage;
    private final float bulletVelocity;
    private final int rateOfFire;
    private final int magSize;
    public final RegistryObject<Item> ammoType;
    private final int reloadCooldown;
    private final float[] bulletSpread;
    private final float[] gunRecoil;
    private final int pelletCount;
    private final LoadingType loadingType;
    private final SoundEvent reloadSoundStart;
    private final SoundEvent reloadSoundMagOut;
    private final SoundEvent reloadSoundMagIn;
    private final SoundEvent reloadSoundEnd;
    private final SoundEvent shootSound;
    private final SoundEvent postShootSound;
    private final int reloadCycles;
    private final boolean unscopeAfterShot;
    private final int reloadStage1;
    private final int reloadStage2;
    private final int reloadStage3;
    private final int inspectTick;
    public final FiringType firingType;
    public final ArmType armType;
    public final MuzzleType muzzleType;
    public final GunProperties gunProperties;
    private final float fireShakeMultiplier;
    private final int fireShakeRadius;
    private final int fireShakeDuration;
    private final int fireShakeFadeDuration;
    private final RenderType muzzleFlashType;
    private final float muzzleFlashSizeNormal;
    private final float muzzleFlashSizeAim;
    private final int muzzleVariant;
    private final float fovModifier;
    protected final AnimatableInstanceCache animationCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public GunItem(Item.Properties settings, String gunID, String animationID, float bulletDamage, float bulletVelocity, int rateOfFire, int magSize, RegistryObject<Item> ammoType, int reloadCooldown, float[] bulletSpread, float[] gunRecoil, int pelletCount, LoadingType loadingType, SoundEvent reloadSoundStart, SoundEvent reloadSoundMagOut, SoundEvent reloadSoundMagIn, SoundEvent reloadSoundEnd, SoundEvent shootSound, SoundEvent postShootSound, int reloadCycles, boolean unscopeAfterShot, int reloadStage1, int reloadStage2, int reloadStage3, int inspectTick, FiringType firingType, ArmType armType, MuzzleType muzzleType, GunProperties gunProperties, float fireShakeMultiplier, int fireShakeRadius, int fireShakeDuration, int fireShakeFadeDuration, RenderType muzzleFlashType, float muzzleFlashSizeNormal, float muzzleFlashSizeAim, int muzzleVariant, float fovModifier) {
        super(settings.m_41503_(magSize * 10 + 1));
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
        this.random = new Random();
        this.gunID = gunID;
        this.animationID = animationID;
        this.bulletDamage = bulletDamage;
        this.bulletVelocity = bulletVelocity;
        this.rateOfFire = rateOfFire;
        this.magSize = magSize;
        this.ammoType = ammoType;
        this.reloadCooldown = reloadCooldown;
        this.bulletSpread = bulletSpread;
        this.gunRecoil = gunRecoil;
        this.pelletCount = pelletCount;
        this.loadingType = loadingType;
        this.reloadSoundStart = reloadSoundStart;
        this.reloadSoundMagOut = reloadSoundMagOut;
        this.reloadSoundMagIn = reloadSoundMagIn;
        this.reloadSoundEnd = reloadSoundEnd;
        this.shootSound = shootSound;
        this.postShootSound = postShootSound;
        this.reloadCycles = reloadCycles;
        this.unscopeAfterShot = unscopeAfterShot;
        this.reloadStage1 = reloadStage1;
        this.reloadStage2 = reloadStage2;
        this.reloadStage3 = reloadStage3;
        this.inspectTick = inspectTick;
        this.firingType = firingType;
        this.armType = armType;
        this.muzzleType = muzzleType;
        this.gunProperties = gunProperties;
        this.fireShakeMultiplier = fireShakeMultiplier;
        this.fireShakeRadius = fireShakeRadius;
        this.fireShakeDuration = fireShakeDuration;
        this.fireShakeFadeDuration = fireShakeFadeDuration;
        this.muzzleFlashType = muzzleFlashType;
        this.muzzleFlashSizeNormal = muzzleFlashSizeNormal;
        this.muzzleFlashSizeAim = muzzleFlashSizeAim;
        this.muzzleVariant = muzzleVariant;
        this.fovModifier = fovModifier;
    }

    public void shoot(Level world, Player user, ItemStack itemStack) {
        LocalPlayer player;
        itemStack.m_41784_().m_128405_("reloadTick", 0);
        itemStack.m_41784_().m_128379_("isReloading", false);
        itemStack.m_41784_().m_128379_("isInspecting", false);
        itemStack.m_41784_().m_128379_("isFiring", true);
        double h_kick = this.getRecoilX(itemStack);
        float v_kick = this.getRecoilY(itemStack);
        if (this.shouldUnscopeAfterShot() && itemStack.m_41784_().m_128471_("isAiming")) {
            itemStack.m_41784_().m_128379_("isAiming", false);
        }
        if (!world.f_46443_) {
            for (int i = 0; i < this.getPelletCount(); ++i) {
                BulletProjectileEntity bulletProjectile = new BulletProjectileEntity((LivingEntity)user, world, this.getBulletDamage(), this.getBulletVelocity());
                double point = (double)(this.random.nextBoolean() ? 1 : -1) * 2.0;
                double pX = (double)this.getBulletSpread()[1] * (double)this.random.nextFloat() + (double)this.random.nextFloat() * (double)(this.getBulletSpread()[0] - this.getBulletSpread()[1]) * point;
                bulletProjectile.m_146884_(user.m_20182_().m_82520_(pX, (double)user.m_20192_(), 0.0));
                bulletProjectile.shoot(user.m_20154_());
                bulletProjectile.m_5602_((Entity)user);
                world.m_7967_((Entity)bulletProjectile);
            }
            long id = GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)world));
            FriendlyByteBuf buf = PacketByteBufs.create();
            buf.m_130070_(itemStack.m_41784_().m_128471_("isAiming") ? "aim_firing" : "firing");
            buf.writeLong(id);
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)user), (ResourceLocation)DawnOfTheFlood.PLAY_ANIMATION_PACKET_ID, (FriendlyByteBuf)buf);
            FriendlyByteBuf buf2 = PacketByteBufs.create();
            buf2.writeFloat(v_kick);
            buf2.writeDouble(h_kick);
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)user), (ResourceLocation)DawnOfTheFlood.RECOIL_PACKET_ID, (FriendlyByteBuf)buf2);
            if (((Boolean)DawnOfTheFloodConfig.SERVER.gun_shot_screen_shake.get()).booleanValue()) {
                ScreenShakeUtils.ScreenShake((Level)world, (Vec3)user.m_20182_(), (float)this.getFireShakeRadius(), (float)this.getFireShakeMultiplier(), (int)this.getFireShakeDuration(), (int)this.getFireShakeFadeDuration());
            }
        }
        if ((player = Minecraft.m_91087_().f_91074_) != null) {
            float initial = 2.2f;
            float distance = ((Double)DawnOfTheFloodConfig.SERVER.gun_shot_sound_distance.get()).floatValue();
            double x = user.m_20185_();
            double y = user.m_20186_();
            double z = user.m_20189_();
            float volume = initial * (1.0f - Math.min(0.8f, (float)Math.sqrt(player.m_20275_(x, y, z)) / distance));
            volume *= volume;
            world.m_5594_(null, user.m_20183_(), this.getShootSound(), SoundSource.PLAYERS, volume, 1.0f);
        }
        if (!user.m_7500_()) {
            itemStack.m_41784_().m_128405_("Clip", itemStack.m_41784_().m_128451_("Clip") - 1);
            itemStack.m_41622_(10, (LivingEntity)user, e -> e.m_21166_(EquipmentSlot.MAINHAND));
        }
        if (this.reloadCycles > 1) {
            itemStack.m_41784_().m_128405_("currentCycle", itemStack.m_41784_().m_128451_("Clip"));
        }
    }

    private void setDefaultNBT(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        nbtCompound.m_128405_("reloadTick", 0);
        nbtCompound.m_128405_("currentCycle", 1);
        nbtCompound.m_128405_("Clip", 0);
        nbtCompound.m_128379_("isReloading", false);
        nbtCompound.m_128379_("isAiming", false);
        nbtCompound.m_128379_("isFiring", false);
        nbtCompound.m_128379_("isInspecting", false);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        this.setDefaultNBT(pStack);
        if (pLevel instanceof ServerLevel) {
            long id = GeoItem.getOrAssignId((ItemStack)pStack, (ServerLevel)((ServerLevel)pLevel));
            this.triggerAnim((Entity)pPlayer, id, "controller", "idle");
        }
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        if (Screen.m_96638_()) {
            pTooltipComponents.add((Component)Component.m_237115_((String)("Ammo: " + pStack.m_41784_().m_128451_("Clip") + "/" + this.magSize)).m_130940_(ChatFormatting.YELLOW));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Damage: " + this.getBulletDamage())).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Recoil: " + Math.sqrt(this.gunRecoil[0] * this.gunRecoil[0] + this.gunRecoil[1] * this.gunRecoil[1]))).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)("RPM: " + (int)(20.0f / (float)this.rateOfFire * 60.0f))).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)("Reload Time: " + (float)this.reloadCooldown / 20.0f + "s")).m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)"Uses:").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)((Item)this.getAmmoType().get()).m_5524_()).m_130940_(ChatFormatting.YELLOW));
        } else {
            pTooltipComponents.add((Component)Component.m_237115_((String)("Ammo: " + pStack.m_41784_().m_128451_("Clip") + "/" + this.magSize)).m_130940_(ChatFormatting.YELLOW));
            pTooltipComponents.add((Component)Component.m_237115_((String)"Uses:").m_130940_(ChatFormatting.GRAY));
            pTooltipComponents.add((Component)Component.m_237115_((String)((Item)this.getAmmoType().get()).m_5524_()).m_130940_(ChatFormatting.YELLOW));
            pTooltipComponents.add((Component)Component.m_237115_((String)"Press Shift to see stats").m_130940_(ChatFormatting.AQUA));
        }
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        CompoundTag nbtCompound = stack.m_41784_();
        boolean isSprinting = entity.m_20142_();
        ItemStack mainHandGun = ((Player)entity).m_21205_();
        if (!nbtCompound.m_128425_("GeckoLibID", 99) && world instanceof ServerLevel) {
            nbtCompound.m_128356_("GeckoLibID", AnimatableIdCache.getFreeId((ServerLevel)((ServerLevel)world)));
        }
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (world.f_46443_) {
            if (animationController.getCurrentAnimation() != null && !animationController.getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
                if (!(!isSprinting || mainHandGun.m_41784_().m_128471_("isAiming") || mainHandGun != stack || mainHandGun.m_41784_().m_128471_("isReloading") || animationController.isPlayingTriggeredAnimation() && animationController.getCurrentAnimation().animation().name().equals("sprinting") || animationController.getCurrentAnimation().animation().name().equals("melee") && !animationController.getAnimationState().equals((Object)AnimationController.State.PAUSED))) {
                    animationController.tryTriggerAnimation("sprinting");
                } else if (!(isSprinting && mainHandGun == stack || !animationController.isPlayingTriggeredAnimation() || !animationController.getCurrentAnimation().animation().name().equals("sprinting") || animationController.getCurrentAnimation().animation().name().equals("melee") && !animationController.getAnimationState().equals((Object)AnimationController.State.PAUSED))) {
                    animationController.tryTriggerAnimation(!mainHandGun.m_41784_().m_128471_("isAiming") ? "idle" : "aim");
                } else if (animationController.getCurrentRawAnimation() == GunAnimations.AIM && !KeybindHelper.getAimMapping().m_90857_()) {
                    animationController.tryTriggerAnimation("idle");
                }
            }
            if (mainHandGun == stack && KeybindHelper.getReloadMapping().m_90857_() && GunItem.remainingAmmo(stack) < this.getMagSize() && GunItem.reserveAmmoCount((Player)entity, (Item)this.getAmmoType().get()) > 0 && !nbtCompound.m_128471_("isReloading") && !isSprinting) {
                FriendlyByteBuf buf = PacketByteBufs.create();
                buf.writeBoolean(true);
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.RELOAD_PACKET_ID, (FriendlyByteBuf)buf);
            }
            if (!(mainHandGun != stack || !KeybindHelper.getInspectMapping().m_90857_() || isSprinting || nbtCompound.m_128471_("isReloading") || nbtCompound.m_128471_("isAiming") || ((Player)entity).m_36335_().m_41519_((Item)this))) {
                ((Player)entity).m_36335_().m_41524_((Item)this, this.getInspectTick());
                FriendlyByteBuf bufX = PacketByteBufs.create();
                bufX.writeBoolean(true);
                ClientPlayNetworking.send((ResourceLocation)DawnOfTheFlood.INSPECT_PACKET_ID, (FriendlyByteBuf)bufX);
            }
        }
        if (mainHandGun == stack) {
            nbtCompound.m_128379_("isAiming", KeybindHelper.getAimMapping().m_90857_());
            nbtCompound.m_128379_("isFiring", KeybindHelper.getShootMapping().m_90857_());
            if (KeybindHelper.getShootMapping().m_90857_() && !nbtCompound.m_128471_("isReloading")) {
                if (!((Player)entity).m_36335_().m_41519_((Item)this) && !entity.m_20142_() && GunItem.isLoaded(stack)) {
                    this.shoot(world, (Player)entity, stack);
                    ((Player)entity).m_36335_().m_41524_((Item)this, this.getRateOfFire());
                    nbtCompound.m_128379_("isFiring", true);
                    nbtCompound.m_128379_("isInspecting", false);
                }
            } else if (KeybindHelper.getAimMapping().m_90857_() && KeybindHelper.getShootMapping().m_90857_() && !nbtCompound.m_128471_("isReloading")) {
                if (!((Player)entity).m_36335_().m_41519_((Item)this) && !entity.m_20142_() && GunItem.isLoaded(stack)) {
                    nbtCompound.m_128379_("isFiring", true);
                    nbtCompound.m_128379_("isAiming", true);
                    animationController.tryTriggerAnimation("aim_firing");
                    nbtCompound.m_128379_("isInspecting", false);
                }
            } else if (KeybindHelper.getAimMapping().m_90857_() && !KeybindHelper.getShootMapping().m_90857_() && !nbtCompound.m_128471_("isReloading") && !entity.m_20142_()) {
                nbtCompound.m_128379_("isAiming", true);
                animationController.tryTriggerAnimation("aim");
            } else {
                nbtCompound.m_128379_("isAiming", false);
            }
        }
        if (mainHandGun != stack && nbtCompound.m_128471_("isAiming")) {
            animationController.tryTriggerAnimation("idle");
            nbtCompound.m_128379_("isAiming", false);
        }
        double relX_kick = this.getAnimationRecoilX();
        float relY_kick = this.getAnimationRecoilY();
        if (nbtCompound.m_128471_("isReloading") && !isSprinting) {
            if (mainHandGun != stack || GunItem.reserveAmmoCount((Player)entity, (Item)this.getAmmoType().get()) <= 0 && this.reloadCycles <= 1 || nbtCompound.m_128451_("reloadTick") >= this.getReloadCooldown() || GunItem.remainingAmmo(stack) >= this.getMagSize() && this.reloadCycles <= 1) {
                nbtCompound.m_128379_("isReloading", false);
            }
            if (!world.f_46443_) {
                FriendlyByteBuf bufA = PacketByteBufs.create();
                bufA.writeFloat(relY_kick);
                bufA.writeDouble(relX_kick);
                ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)entity), (ResourceLocation)DawnOfTheFlood.RELOAD_RECOIL_PACKET_ID, (FriendlyByteBuf)bufA);
            }
            this.doReloadTick(world, nbtCompound, (Player)entity, stack);
        } else {
            if (nbtCompound.m_128451_("reloadTick") > this.reloadStage3 && nbtCompound.m_128451_("reloadTick") <= this.getReloadCooldown()) {
                this.finishReload((Player)entity, stack);
            }
            nbtCompound.m_128379_("isReloading", false);
            nbtCompound.m_128405_("reloadTick", 0);
        }
    }

    private void doReloadTick(Level world, CompoundTag nbtCompound, Player player, ItemStack stack) {
        int rTick = nbtCompound.m_128451_("reloadTick");
        if (world instanceof ServerLevel) {
            long id = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)((ServerLevel)world));
            if (nbtCompound.m_128451_("reloadTick") == this.reloadStage1) {
                this.triggerAnim((Entity)player, id, "controller", "reload_magout");
            } else if (nbtCompound.m_128451_("reloadTick") == this.reloadStage2) {
                this.triggerAnim((Entity)player, id, "controller", "reload_magin");
            } else if (nbtCompound.m_128451_("reloadTick") == this.reloadStage3) {
                this.triggerAnim((Entity)player, id, "controller", "reload_end");
            }
        }
        nbtCompound.m_128405_("reloadTick", nbtCompound.m_128451_("reloadTick") + 1);
        switch (this.getLoadingType()) {
            case MAGAZINE: {
                if (rTick < this.getReloadCooldown() || GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) <= 0) break;
                nbtCompound.m_128405_("currentCycle", 1);
                this.finishReload(player, stack);
                nbtCompound.m_128405_("reloadTick", 0);
                break;
            }
            case PER_CARTRIDGE: {
                if (rTick < this.reloadStage3 || nbtCompound.m_128451_("currentCycle") >= this.reloadCycles || GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) <= 0) break;
                nbtCompound.m_128405_("Clip", nbtCompound.m_128451_("Clip") + 1);
                if (!player.m_7500_() || !player.m_5833_()) {
                    GunInventoryHelper.removeItemFromInventory(player, (Item)this.getAmmoType().get(), 1);
                }
                if (GunItem.remainingAmmo(stack) < this.getMagSize() && GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) > 0) {
                    nbtCompound.m_128405_("reloadTick", this.reloadStage2);
                }
                nbtCompound.m_128405_("currentCycle", nbtCompound.m_128451_("Clip"));
                stack.m_41721_(this.m_41462_() - (nbtCompound.m_128451_("Clip") * 10 + 1));
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return null;
    }

    public float getRecoilX(ItemStack stack) {
        boolean rd = this.random.nextBoolean();
        return stack.m_41784_().m_128471_("isAiming") ? (rd ? this.gunRecoil[0] : -this.gunRecoil[0]) / 2.0f : (rd ? this.gunRecoil[0] : -this.gunRecoil[0]);
    }

    public float getRecoilY(ItemStack stack) {
        return stack.m_41784_().m_128471_("isAiming") ? this.gunRecoil[1] / 2.0f : this.gunRecoil[1];
    }

    public float getAnimationRecoilX() {
        return ((this.gunRecoil[0] + this.gunRecoil[1] / (float)this.random.nextInt(6)) / this.gunRecoil[this.random.nextBoolean() ? 0 : 1] + 0.1f) * (float)(this.random.nextBoolean() ? 1 : -1);
    }

    public float getAnimationRecoilY() {
        return this.gunRecoil[0] / this.gunRecoil[1] * (float)Math.pow(this.gunRecoil[1], this.gunRecoil[0]) * 0.25f * (float)(this.random.nextBoolean() ? 1 : -1);
    }

    public static boolean isLoaded(ItemStack stack) {
        return GunItem.remainingAmmo(stack) > 0;
    }

    public void finishReload(Player player, ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        int ammoToLoad = this.getMagSize() - nbtCompound.m_128451_("Clip");
        if (GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()) >= ammoToLoad) {
            nbtCompound.m_128405_("Clip", nbtCompound.m_128451_("Clip") + ammoToLoad);
            if (!player.m_7500_() || !player.m_5833_()) {
                GunInventoryHelper.removeItemFromInventory(player, (Item)this.getAmmoType().get(), ammoToLoad);
            }
        } else {
            nbtCompound.m_128405_("Clip", nbtCompound.m_128451_("Clip") + GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()));
            if (!player.m_7500_() || !player.m_5833_()) {
                GunInventoryHelper.removeItemFromInventory(player, (Item)this.getAmmoType().get(), GunItem.reserveAmmoCount(player, (Item)this.getAmmoType().get()));
            }
        }
        stack.m_41721_(this.m_41462_() - (nbtCompound.m_128451_("Clip") * 10 + 1));
    }

    public void aimAnimation(ItemStack stack, boolean aim, ServerLevel world, Player player) {
        stack.m_41784_().m_128379_("isAiming", aim);
        long id = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)world);
        this.triggerAnim((Entity)player, id, "controller", aim ? "aim" : "idle");
    }

    public void toggleSprint(ItemStack stack, boolean sprint, ServerLevel world, Player player) {
        long id = GeoItem.getOrAssignId((ItemStack)stack, (ServerLevel)world);
        if (stack.m_41784_().m_128471_("isReloading")) {
            return;
        }
        if (sprint) {
            this.triggerAnim((Entity)player, id, "controller", "sprinting");
        }
    }

    public static int remainingAmmo(ItemStack stack) {
        CompoundTag nbtCompound = stack.m_41784_();
        return nbtCompound.m_128451_("Clip");
    }

    public static int reserveAmmoCount(Player player, Item item) {
        return GunInventoryHelper.itemCountInInventory(player, item);
    }

    public boolean m_6813_(ItemStack pStack, Level pLevel, BlockState pState, BlockPos pPos, LivingEntity pMiningEntity) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public int m_142159_(ItemStack pStack) {
        return Objects.requireNonNull(ChatFormatting.YELLOW.m_126665_());
    }

    public Predicate<ItemStack> m_6437_() {
        return null;
    }

    public int m_6615_() {
        return 0;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new GunRenderer(new ResourceLocation("dotf", GunItem.this.gunID));
                }
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState<GunItem> event) {
        if (event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().tryTriggerAnimation("idle");
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animationCache;
    }

    public double getTick(Object itemStack) {
        return RenderUtils.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 1, this::predicate).triggerableAnim("idle", GunAnimations.IDLE).triggerableAnim("firing", GunAnimations.FIRING).triggerableAnim("reload_start", GunAnimations.RELOAD_START).triggerableAnim("reload_magout", GunAnimations.RELOAD_MAGOUT).triggerableAnim("reload_magin", GunAnimations.RELOAD_MAGIN).triggerableAnim("reload_end", GunAnimations.RELOAD_END).triggerableAnim("inspect", GunAnimations.INSPECT).triggerableAnim("aim", GunAnimations.AIM).triggerableAnim("aim_firing", GunAnimations.AIM_FIRING).triggerableAnim("aim_reload_start", GunAnimations.AIM_RELOAD_START).triggerableAnim("sprinting", GunAnimations.SPRINTING);
        controller.setSoundKeyframeHandler(this::soundListener);
        controllers.add(new AnimationController[]{controller});
    }

    private void soundListener(SoundKeyframeEvent<GunItem> gunItemSoundKeyframeEvent) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            switch (gunItemSoundKeyframeEvent.getKeyframeData().getSound()) {
                case "reload_start": {
                    player.m_5496_(this.getReloadSoundStart(), 1.0f, 1.0f);
                    break;
                }
                case "reload_magout": {
                    player.m_5496_(this.getReloadSoundMagOut(), 1.0f, 1.0f);
                    break;
                }
                case "reload_magin": {
                    player.m_5496_(this.getReloadSoundMagIn(), 1.0f, 1.0f);
                    break;
                }
                case "reload_end": {
                    player.m_5496_(this.getReloadSoundEnd(), 1.0f, 1.0f);
                    break;
                }
                case "post_shoot": {
                    player.m_5496_(this.getPostShootSound(), 1.35f, 0.95f);
                    break;
                }
                case "inspect1": {
                    player.m_5496_(SoundEvents.f_271165_, 1.0f, 1.0f);
                    break;
                }
                case "inspect2": {
                    player.m_5496_(SoundEvents.f_271165_, 1.0f, 1.0f);
                }
            }
        }
    }

    public String getID() {
        return this.gunID;
    }

    public String getAnimationID() {
        return this.animationID;
    }

    public RegistryObject<Item> getAmmoType() {
        return this.ammoType;
    }

    public float getBulletDamage() {
        return this.bulletDamage;
    }

    public float getBulletVelocity() {
        return this.bulletVelocity;
    }

    public int getRateOfFire() {
        return this.rateOfFire;
    }

    public int getPelletCount() {
        return this.pelletCount;
    }

    public int getMagSize() {
        return this.magSize;
    }

    public float[] getBulletSpread() {
        return this.bulletSpread;
    }

    public float[] getGunRecoil() {
        return this.gunRecoil;
    }

    public int getReloadCooldown() {
        return this.reloadCooldown;
    }

    public boolean shouldUnscopeAfterShot() {
        return this.unscopeAfterShot;
    }

    public int getFireShakeRadius() {
        return this.fireShakeRadius;
    }

    public int getFireShakeFadeDuration() {
        return this.fireShakeFadeDuration;
    }

    public int getFireShakeDuration() {
        return this.fireShakeDuration;
    }

    public float getFireShakeMultiplier() {
        return this.fireShakeMultiplier;
    }

    public SoundEvent getShootSound() {
        return this.shootSound;
    }

    public SoundEvent getReloadSoundStart() {
        return this.reloadSoundStart;
    }

    public SoundEvent getReloadSoundMagIn() {
        return this.reloadSoundMagIn;
    }

    public SoundEvent getReloadSoundMagOut() {
        return this.reloadSoundMagOut;
    }

    public SoundEvent getReloadSoundEnd() {
        return this.reloadSoundEnd;
    }

    public SoundEvent getPostShootSound() {
        return this.postShootSound;
    }

    public float getMuzzleFlashSizeNormal() {
        return this.muzzleFlashSizeNormal;
    }

    public float getMuzzleFlashSizeAim() {
        return this.muzzleFlashSizeAim;
    }

    public float getFovModifier() {
        return this.fovModifier;
    }

    public int getInspectTick() {
        return this.inspectTick;
    }

    public LoadingType getLoadingType() {
        return this.loadingType;
    }

    public FiringType getFiringType() {
        return this.firingType;
    }

    public MuzzleType getMuzzleType() {
        return this.muzzleType;
    }

    public RenderType getMuzzleFlashType() {
        return this.muzzleFlashType;
    }

    public ArmType getArmType() {
        return this.armType;
    }

    public int getMuzzleVariant() {
        return this.muzzleVariant;
    }

    public GunProperties getGunProperties() {
        return this.gunProperties;
    }

    public static enum LoadingType {
        MAGAZINE,
        PER_CARTRIDGE;

    }

    public static enum FiringType {
        SEMI_AUTO,
        AUTO;

    }

    public static enum ArmType {
        HANDGUN_ONEHAND,
        HANDGUN_TWOHAND,
        LONG_GUNS;

    }

    public static enum MuzzleType {
        NORMAL,
        EMERALD,
        PLASMA,
        AMETHYST,
        RUBY,
        NONE;

    }

    public static enum GunProperties {
        NORMAL,
        NEEDLER;

    }
}

