/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.mixin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.teamabyssalofficial.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.util.WorldDataUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Witch.class})
public abstract class WitchMixin
extends Raider
implements RangedAttackMob {
    protected WitchMixin(EntityType<? extends Raider> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="HEAD")}, method={"aiStep"})
    public void aiStep(CallbackInfo ci) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.m_5448_() != null && this.dawnOfTheFlood$commonHelp(this.m_5448_()) && this.dawnOfTheFlood$hasArmistice(this.m_9236_()) && ((Boolean)DawnOfTheFloodConfig.SERVER.illager_human_alliance.get()).booleanValue()) {
            this.m_6710_(null);
        }
    }

    @Unique
    public boolean dawnOfTheFlood$commonHelp(LivingEntity livingEntity) {
        if (this.m_21188_() == livingEntity) {
            this.m_6710_(livingEntity);
            return false;
        }
        return livingEntity instanceof Player || livingEntity instanceof Villager || livingEntity instanceof IronGolem;
    }

    @Unique
    public boolean dawnOfTheFlood$hasArmistice(Level level) {
        ServerLevel world;
        return level instanceof ServerLevel && WorldDataUtils.getWorldDataRegistry(world = (ServerLevel)level).getWave() > (Integer)DawnOfTheFloodConfig.SERVER.illager_human_alliance_wave.get();
    }
}

