/*
 * Decompiled with CFR 0.152.
 */
package net.teamabyssalofficial.registry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.teamabyssalofficial.config.DawnOfTheFloodConfig;
import net.teamabyssalofficial.entity.custom.CarrierFormEntity;
import net.teamabyssalofficial.entity.custom.DeadHumanFormEntity;
import net.teamabyssalofficial.entity.custom.DeadPlayerFormEntity;
import net.teamabyssalofficial.entity.custom.DeadSangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.DeadVillagerFormEntity;
import net.teamabyssalofficial.entity.custom.HumanFormEntity;
import net.teamabyssalofficial.entity.custom.PlayerFormEntity;
import net.teamabyssalofficial.entity.custom.PodInfectorEntity;
import net.teamabyssalofficial.entity.custom.SangheiliFormEntity;
import net.teamabyssalofficial.entity.custom.VillagerFormEntity;
import net.teamabyssalofficial.guns.bullet.AbstractBullet;
import net.teamabyssalofficial.guns.bullet.BulletProjectileEntity;

public class EntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"dotf");
    public static final MobCategory FLOOD = MobCategory.create((String)"flood", (String)"flood", (int)((Integer)DawnOfTheFloodConfig.SERVER.mob_cap.get()), (boolean)false, (boolean)false, (int)128);
    public static final List<Entity> FLOOD_FORMS = new ArrayList<Entity>();
    public static final RegistryObject<EntityType<PodInfectorEntity>> POD_INFECTOR = ENTITY_TYPES.register("pod_infector", () -> EntityType.Builder.m_20704_(PodInfectorEntity::new, (MobCategory)FLOOD).m_20699_(0.85f, 0.95f).m_20712_(new ResourceLocation("dotf", "pod_infector").toString()));
    public static final RegistryObject<EntityType<HumanFormEntity>> HUMAN_FORM = ENTITY_TYPES.register("human_form", () -> EntityType.Builder.m_20704_(HumanFormEntity::new, (MobCategory)FLOOD).m_20699_(1.4f, 2.1f).m_20712_(new ResourceLocation("dotf", "human_form").toString()));
    public static final RegistryObject<EntityType<VillagerFormEntity>> VILLAGER_FORM = ENTITY_TYPES.register("villager_form", () -> EntityType.Builder.m_20704_(VillagerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.4f, 2.1f).m_20712_(new ResourceLocation("dotf", "villager_form").toString()));
    public static final RegistryObject<EntityType<PlayerFormEntity>> PLAYER_FORM = ENTITY_TYPES.register("player_form", () -> EntityType.Builder.m_20704_(PlayerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.4f, 2.1f).m_20712_(new ResourceLocation("dotf", "player_form").toString()));
    public static final RegistryObject<EntityType<SangheiliFormEntity>> SANGHEILI_FORM = ENTITY_TYPES.register("sangheili_form", () -> EntityType.Builder.m_20704_(SangheiliFormEntity::new, (MobCategory)FLOOD).m_20699_(1.65f, 3.2f).m_20712_(new ResourceLocation("dotf", "sangheili_form").toString()));
    public static final RegistryObject<EntityType<CarrierFormEntity>> CARRIER_FORM = ENTITY_TYPES.register("carrier_form", () -> EntityType.Builder.m_20704_(CarrierFormEntity::new, (MobCategory)FLOOD).m_20699_(1.35f, 2.25f).m_20712_(new ResourceLocation("dotf", "carrier_form").toString()));
    public static final RegistryObject<EntityType<DeadHumanFormEntity>> DEAD_HUMAN_FORM = ENTITY_TYPES.register("dead_human_form", () -> EntityType.Builder.m_20704_(DeadHumanFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_human_form").toString()));
    public static final RegistryObject<EntityType<DeadPlayerFormEntity>> DEAD_PLAYER_FORM = ENTITY_TYPES.register("dead_player_form", () -> EntityType.Builder.m_20704_(DeadPlayerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_player_form").toString()));
    public static final RegistryObject<EntityType<DeadVillagerFormEntity>> DEAD_VILLAGER_FORM = ENTITY_TYPES.register("dead_villager_form", () -> EntityType.Builder.m_20704_(DeadVillagerFormEntity::new, (MobCategory)FLOOD).m_20699_(1.95f, 0.85f).m_20712_(new ResourceLocation("dotf", "dead_villager_form").toString()));
    public static final RegistryObject<EntityType<DeadSangheiliFormEntity>> DEAD_SANGHEILI_FORM = ENTITY_TYPES.register("dead_sangheili_form", () -> EntityType.Builder.m_20704_(DeadSangheiliFormEntity::new, (MobCategory)FLOOD).m_20699_(2.25f, 1.05f).m_20712_(new ResourceLocation("dotf", "dead_sangheili_form").toString()));
    public static final RegistryObject<EntityType<BulletProjectileEntity>> BULLET_PROJECTILE = ENTITY_TYPES.register("bullet_projectile", () -> EntityType.Builder.m_20704_(BulletProjectileEntity::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.35f, 0.35f).m_20702_(64).m_20712_(new ResourceLocation("dotf", "bullet_projectile").toString()));
    public static final RegistryObject<EntityType<AbstractBullet>> BULLET = ENTITY_TYPES.register("bullet", () -> EntityType.Builder.m_20704_(AbstractBullet::new, (MobCategory)MobCategory.MISC).m_20698_().m_20719_().m_20699_(0.35f, 0.35f).m_20702_(64).m_20712_(new ResourceLocation("dotf", "bullet").toString()));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return ENTITY_TYPES.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }
}

