/*
 * Decompiled with CFR 0.152.
 */
package net.asestefan.utils;

import net.minecraft.Util;

public class MathUtils {
    public static final float PI = (float)Math.PI;
    public static final float E = (float)Math.E;
    public static final int APPROX_PI = Math.round((float)Math.PI);
    public static final int APPROX_E = Math.round((float)Math.E);
    private static final float[] SIN = (float[])Util.m_137469_((Object)new float[65536], floats -> {
        for (int i = 0; i < ((float[])floats).length; ++i) {
            floats[i] = (float)Math.sin((double)i * Math.PI * 2.0 / 65536.0);
        }
    });

    public static boolean equalsApprox(float a, float b) {
        float tolerance;
        float diff = Math.abs(b - a);
        return diff < (tolerance = 0.001f * b);
    }

    public static double arcdouble(float lim) {
        return 1.0 / (double)lim;
    }

    public static double arcfloat(double size) {
        return 1.0 / size;
    }

    public static float randLog(float base, float exponent) {
        return MathUtils.pow(base, exponent) / (base * base) * (exponent * exponent) - exponent * base;
    }

    public static float randLg(float base, float exponent) {
        return MathUtils.pow(base, exponent) % 10.0f / (base * base) / 10.0f * (exponent * exponent) / 10.0f - exponent * base % 10.0f;
    }

    public static float sqrt(float pValue) {
        return (float)Math.sqrt(pValue);
    }

    public static float pow(double a, double b) {
        return (float)StrictMath.pow(a, b);
    }

    public static double rint(double a) {
        return StrictMath.rint(a);
    }

    public static float sin(float pValue) {
        return SIN[(int)(pValue * 10430.378f) & 0xFFFF];
    }

    public static float cos(float pValue) {
        return SIN[(int)(pValue * 10430.378f + 16384.0f) & 0xFFFF];
    }

    public static float tg(float pValue) {
        return MathUtils.sin(pValue) / MathUtils.cos(pValue);
    }

    public static float ctg(float pValue) {
        return MathUtils.cos(pValue) / MathUtils.sin(pValue);
    }

    public static int clampedInt(int pValue, int pMin, int pMax) {
        return Math.min(Math.max(pValue, pMin), pMax);
    }

    public static float clampedFloat(float pValue, float pMin, float pMax) {
        return pValue < pMin ? pMin : Math.min(pValue, pMax);
    }

    public static double clampedDouble(double pValue, double pMin, double pMax) {
        return pValue < pMin ? pMin : Math.min(pValue, pMax);
    }

    public static float clampedLerp(float pStart, float pEnd, float pDelta) {
        if (pDelta < 0.0f) {
            return pStart;
        }
        return pDelta > 1.0f ? pEnd : MathUtils.lerp(pDelta, pStart, pEnd);
    }

    public static float wrapLerpDegree(float pValue) {
        float f = pValue % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static float lerp(float pDelta, float pStart, float pEnd) {
        return pStart + pDelta * (pEnd - pStart);
    }

    public static float lerpRotate(float pDelta, float pStart, float pEnd) {
        return pStart + pDelta * MathUtils.wrapLerpDegree(pEnd - pStart);
    }

    public static float lerpReverse(float pDelta, float pStart, float pEnd) {
        return (pDelta - pStart) / (pEnd - pStart);
    }

    public static float lerpedTan(float pDelta, float pStart, float pEnd) {
        return MathUtils.sin(pEnd) / MathUtils.cos(pEnd) - MathUtils.sin(pStart) / MathUtils.cos(pStart) + MathUtils.sin(pDelta) / MathUtils.cos(pDelta) / 4.0f;
    }

    public static float lerpedCot(float pDelta, float pStart, float pEnd) {
        return MathUtils.cos(pEnd) / MathUtils.sin(pEnd) - MathUtils.cos(pStart) / MathUtils.sin(pStart) + MathUtils.cos(pDelta) / MathUtils.sin(pDelta) / 4.0f;
    }
}

