/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.remapped.render;

import dev.worldgen.remapped.map.RemappedState;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_1921;
import net.minecraft.class_20;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_7833;
import net.minecraft.class_9209;
import net.minecraft.class_9443;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class RemappedMapRenderer
implements AutoCloseable {
    final class_1060 textureManager;
    final class_9443 mapDecorationsAtlasManager;
    private final Int2ObjectMap<MapTexture> mapTextures = new Int2ObjectOpenHashMap();

    public RemappedMapRenderer(class_1060 textureManager, class_9443 mapDecorationsAtlasManager) {
        this.textureManager = textureManager;
        this.mapDecorationsAtlasManager = mapDecorationsAtlasManager;
    }

    public void updateTexture(class_9209 id, RemappedState state) {
        this.getMapTexture(id, state).setNeedsUpdate();
    }

    public void draw(class_4587 matrices, class_4597 vertexConsumers, class_9209 id, RemappedState state, boolean hidePlayerIcons, int light) {
        this.getMapTexture(id, state).draw(matrices, vertexConsumers, hidePlayerIcons, light);
    }

    private MapTexture getMapTexture(class_9209 component, RemappedState state) {
        return (MapTexture)this.mapTextures.compute(component.comp_2315(), (id, texture) -> {
            if (texture == null) {
                return new MapTexture((int)id, state);
            }
            texture.setState(state);
            return texture;
        });
    }

    public void clearStateTextures() {
        for (MapTexture texture : this.mapTextures.values()) {
            texture.close();
        }
        this.mapTextures.clear();
    }

    @Override
    public void close() {
        this.clearStateTextures();
    }

    @Environment(value=EnvType.CLIENT)
    private class MapTexture
    implements AutoCloseable {
        private RemappedState state;
        private final class_1043 texture;
        private final class_1921 renderLayer;
        private boolean needsUpdate = true;

        MapTexture(int id, RemappedState state) {
            this.state = state;
            this.texture = new class_1043(128, 128, true);
            class_2960 identifier = RemappedMapRenderer.this.textureManager.method_4617("map/" + id, this.texture);
            this.renderLayer = class_1921.method_23028((class_2960)identifier);
        }

        void setState(RemappedState state) {
            boolean bl = this.state != state;
            this.state = state;
            this.needsUpdate |= bl;
        }

        public void setNeedsUpdate() {
            this.needsUpdate = true;
        }

        private void updateTexture() {
            for (int i = 0; i < 128; ++i) {
                for (int j = 0; j < 128; ++j) {
                    int k = j + i * 128;
                    this.texture.method_4525().method_4305(j, i, this.state.getPixelColor(k));
                }
            }
            this.texture.method_4524();
        }

        void draw(class_4587 matrices, class_4597 vertexConsumers, boolean hidePlayerIcons, int light) {
            if (this.needsUpdate) {
                this.updateTexture();
                this.needsUpdate = false;
            }
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            class_4588 vertexConsumer = vertexConsumers.getBuffer(this.renderLayer);
            vertexConsumer.method_22918(matrix4f, 0.0f, 128.0f, -0.01f).method_39415(-1).method_22913(0.0f, 1.0f).method_60803(light);
            vertexConsumer.method_22918(matrix4f, 128.0f, 128.0f, -0.01f).method_39415(-1).method_22913(1.0f, 1.0f).method_60803(light);
            vertexConsumer.method_22918(matrix4f, 128.0f, 0.0f, -0.01f).method_39415(-1).method_22913(1.0f, 0.0f).method_60803(light);
            vertexConsumer.method_22918(matrix4f, 0.0f, 0.0f, -0.01f).method_39415(-1).method_22913(0.0f, 0.0f).method_60803(light);
            int k = 0;
            for (class_20 mapDecoration : this.state.getDecorations()) {
                if (hidePlayerIcons && !mapDecoration.method_94()) continue;
                matrices.method_22903();
                matrices.method_46416(0.0f + (float)mapDecoration.comp_1843() / 2.0f + 64.0f, 0.0f + (float)mapDecoration.comp_1844() / 2.0f + 64.0f, -0.02f);
                matrices.method_22907(class_7833.field_40718.rotationDegrees((float)(mapDecoration.comp_1845() * 360) / 16.0f));
                matrices.method_22905(4.0f, 4.0f, 3.0f);
                matrices.method_46416(-0.125f, 0.125f, 0.0f);
                Matrix4f matrix4f2 = matrices.method_23760().method_23761();
                float g = -0.001f;
                class_1058 sprite = RemappedMapRenderer.this.mapDecorationsAtlasManager.method_58516(mapDecoration);
                float h = sprite.method_4594();
                float l = sprite.method_4593();
                float m = sprite.method_4577();
                float n = sprite.method_4575();
                class_4588 vertexConsumer2 = vertexConsumers.getBuffer(class_1921.method_23028((class_2960)sprite.method_45852()));
                vertexConsumer2.method_22918(matrix4f2, -1.0f, 1.0f, (float)k * -0.001f).method_39415(-1).method_22913(h, l).method_60803(light);
                vertexConsumer2.method_22918(matrix4f2, 1.0f, 1.0f, (float)k * -0.001f).method_39415(-1).method_22913(m, l).method_60803(light);
                vertexConsumer2.method_22918(matrix4f2, 1.0f, -1.0f, (float)k * -0.001f).method_39415(-1).method_22913(m, n).method_60803(light);
                vertexConsumer2.method_22918(matrix4f2, -1.0f, -1.0f, (float)k * -0.001f).method_39415(-1).method_22913(h, n).method_60803(light);
                matrices.method_22909();
                if (mapDecoration.comp_1846().isPresent()) {
                    class_327 textRenderer = class_310.method_1551().field_1772;
                    class_2561 text = (class_2561)mapDecoration.comp_1846().get();
                    float o = textRenderer.method_27525((class_5348)text);
                    float var10000 = 25.0f / o;
                    Objects.requireNonNull(textRenderer);
                    float p = class_3532.method_15363((float)var10000, (float)0.0f, (float)0.6666667f);
                    matrices.method_22903();
                    matrices.method_46416(0.0f + (float)mapDecoration.comp_1843() / 2.0f + 64.0f - o * p / 2.0f, 0.0f + (float)mapDecoration.comp_1844() / 2.0f + 64.0f + 4.0f, -0.025f);
                    matrices.method_22905(p, p, 1.0f);
                    matrices.method_46416(0.0f, 0.0f, -0.1f);
                    textRenderer.method_30882(text, 0.0f, 0.0f, -1, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, Integer.MIN_VALUE, light);
                    matrices.method_22909();
                }
                ++k;
            }
        }

        @Override
        public void close() {
            this.texture.close();
        }
    }
}

