/*
 * Decompiled with CFR 0.152.
 */
package kr.shihyeon.imagicthud.hud;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kr.shihyeon.imagicthud.config.ImagictHudConfig;
import kr.shihyeon.imagicthud.util.PlayerUtil;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_640;
import net.minecraft.class_6880;

public class TextGui {
    public static void renderText(class_332 context, class_310 client, String text, int x, int y, int color, boolean shadow) {
        if (client != null && client.field_1772 != null) {
            context.method_51433(client.field_1772, text, x, y, color, shadow);
        }
    }

    public static List<String> getStrings(class_310 client, ImagictHudConfig config, class_640 playerListEntry) {
        ArrayList<String> textLines = new ArrayList<String>();
        String nickname = "";
        if (client.field_1724 != null) {
            nickname = PlayerUtil.getName(client, playerListEntry);
        }
        if (config.enableTopCustomHud) {
            String topCustomLabelText = config.topCustomLabelText;
            textLines.add(topCustomLabelText);
        }
        if (config.enableLocalDateTimeHud) {
            LocalDateTime currentDateTime = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MM/dd HH:mm");
            String currentLocalDateTime = currentDateTime.format(formatter);
            textLines.add(currentLocalDateTime);
        }
        if (config.enableNicknameHud) {
            textLines.add(nickname);
        }
        if (config.enableCoordinatesHud) {
            assert (client.field_1724 != null);
            int playerPosX = class_3532.method_15357((double)client.field_1724.method_23317());
            int playerPosY = class_3532.method_15357((double)client.field_1724.method_5829().field_1322);
            int playerPosZ = class_3532.method_15357((double)client.field_1724.method_23321());
            textLines.add(playerPosX + ", " + playerPosY + ", " + playerPosZ);
        }
        if (config.enableBiomeHud) {
            assert (client.field_1724 != null);
            class_2338 playerPos = client.field_1724.method_24515();
            if (client.field_1687 != null) {
                class_6880 biomeEntry = client.field_1687.method_23753(playerPos);
                class_5321 biomeKey = (class_5321)biomeEntry.method_40230().orElseThrow(() -> new IllegalStateException("Biome key not found"));
                String biomeTranslationKey = "biome.minecraft." + biomeKey.method_29177().method_12832();
                String biomeName = class_2561.method_43471((String)biomeTranslationKey).getString();
                textLines.add(biomeName);
            } else {
                textLines.add("Unknown Biome");
            }
        }
        if (config.enableBottomCustomHud) {
            String bottomCustomLabelText = config.bottomCustomLabelText;
            textLines.add(bottomCustomLabelText);
        }
        return textLines;
    }

    public static String getLongestString(List<String> textLines) {
        return textLines.stream().reduce("", (longestText, text) -> longestText.length() < text.length() ? text : longestText);
    }
}

