/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.client.EnderLuggageRenderer;
import com.gizmo.luggage.client.LuggageModel;
import com.gizmo.luggage.client.LuggageRenderer;
import com.gizmo.luggage.client.LuggageTooltipComponent;
import com.gizmo.luggage.entity.AbstractLuggage;
import com.gizmo.luggage.item.LuggageItem;
import com.gizmo.luggage.network.CallLuggagePacket;
import com.gizmo.luggage.network.SitNearbyLuggagesPacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientEvents {
    public static final ModelLayerLocation LUGGAGE = new ModelLayerLocation(new ResourceLocation("luggage", "luggage"), "main");
    private static final KeyMapping CALL_KEY = new KeyMapping("keybind.luggage.call", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 96, "key.categories.misc");
    private static final KeyMapping WAIT_KEY = new KeyMapping("keybind.luggage.wait", (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.ALT, InputConstants.Type.KEYSYM, 96, "key.categories.misc");

    public static void init(IEventBus bus) {
        bus.addListener(RegisterKeyMappingsEvent.class, event -> {
            event.register(CALL_KEY);
            event.register(WAIT_KEY);
        });
        bus.addListener(EntityRenderersEvent.RegisterLayerDefinitions.class, event -> event.registerLayerDefinition(LUGGAGE, LuggageModel::create));
        bus.addListener(EntityRenderersEvent.RegisterRenderers.class, event -> {
            event.registerEntityRenderer((EntityType)LuggageRegistries.EntityRegistry.LUGGAGE.get(), LuggageRenderer::new);
            event.registerEntityRenderer((EntityType)LuggageRegistries.EntityRegistry.ENDER_LUGGAGE.get(), EnderLuggageRenderer::new);
        });
        bus.addListener(RegisterClientTooltipComponentFactoriesEvent.class, event -> event.register(LuggageItem.Tooltip.class, LuggageTooltipComponent::new));
        NeoForge.EVENT_BUS.addListener(ClientEvents::commandTheCreatures);
        NeoForge.EVENT_BUS.addListener(ClientEvents::attackThroughLuggage);
    }

    private static void commandTheCreatures(InputEvent.Key event) {
        if (event.getAction() == 1 && Minecraft.getInstance().player != null) {
            float pitch = Minecraft.getInstance().player.getRandom().nextFloat() * 0.1f + 0.9f;
            if (event.getKey() == CALL_KEY.getKey().getValue() && CALL_KEY.consumeClick()) {
                Minecraft.getInstance().player.playSound((SoundEvent)LuggageRegistries.SoundRegistry.WHISTLE_CALL.get(), 1.0f, pitch);
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new CallLuggagePacket()});
            } else if (event.getKey() == WAIT_KEY.getKey().getValue() && WAIT_KEY.consumeClick()) {
                Minecraft.getInstance().player.playSound((SoundEvent)LuggageRegistries.SoundRegistry.WHISTLE_WAIT.get(), 0.85f, pitch);
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SitNearbyLuggagesPacket()});
            }
        }
    }

    private static void attackThroughLuggage(InputEvent.InteractionKeyMappingTriggered event) {
        EntityHitResult result;
        HitResult hitResult;
        if (!event.isCanceled() && event.isAttack() && (hitResult = Minecraft.getInstance().hitResult) instanceof EntityHitResult && (result = (EntityHitResult)hitResult).getEntity() instanceof AbstractLuggage) {
            event.setCanceled(true);
            event.setSwingHand(true);
            LocalPlayer player = Minecraft.getInstance().player;
            Vec3 vec3 = player.getEyePosition(1.0f);
            Vec3 vec31 = player.getViewVector(1.0f);
            double d0 = (double)Minecraft.getInstance().gameMode.getPickRange() + 1.5;
            double d1 = Minecraft.getInstance().hitResult.getLocation().distanceToSqr(vec3) + 8.0;
            Vec3 vec32 = vec3.add(vec31.x() * d0, vec31.y() * d0, vec31.z() * d0);
            AABB aabb = player.getBoundingBox().expandTowards(vec31.scale(d0)).inflate(1.0, 1.0, 1.0);
            EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, entity -> !entity.isSpectator() && entity.isPickable() && !(entity instanceof AbstractLuggage), (double)d1);
            if (entityhitresult != null) {
                Minecraft.getInstance().gameMode.attack((Player)player, entityhitresult.getEntity());
            }
        }
    }
}

