/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.entity.AbstractLuggage;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class LuggageModel<T extends AbstractLuggage>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart lid;
    private final ModelPart[] legs = new ModelPart[21];

    public LuggageModel(ModelPart root) {
        this.root = root;
        this.lid = root.getChild("lid");
        for (int i = 0; i < this.legs.length; ++i) {
            this.legs[i] = root.getChild("leg_" + i);
        }
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partDefinition = mesh.getRoot();
        partDefinition.addOrReplaceChild("lid", CubeListBuilder.create().texOffs(0, 22).addBox(-8.0f, -1.0f, -8.0f, 16.0f, 2.0f, 8.0f, new CubeDeformation(0.01f)), PartPose.offset((float)0.0f, (float)13.0f, (float)4.0f));
        partDefinition.addOrReplaceChild("base", CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, 0.0f, -4.0f, 16.0f, 7.0f, 8.0f), PartPose.offset((float)0.0f, (float)13.0f, (float)0.0f));
        for (int i = 0; i < 21; ++i) {
            int x = i % 7;
            int z = i % 3;
            partDefinition.addOrReplaceChild("leg_" + i, CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.offset((float)((float)x * 2.0f - 6.0f), (float)20.0f, (float)((float)z * 2.0f - 2.0f)));
        }
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float headYaw, float headPitch) {
        this.lid.xRot = Math.min(0.0f, Mth.cos((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount * 0.75f);
        for (int i = 0; i < this.legs.length; ++i) {
            int x = i % 7;
            int z = i % 3;
            this.legs[i].xRot = Mth.cos((float)(limbSwing + (float)(x * z) * 0.6662f)) * 1.4f * limbSwingAmount;
        }
    }
}

