/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.client;

import com.gizmo.luggage.client.ClientEvents;
import com.gizmo.luggage.client.LuggageModel;
import com.gizmo.luggage.entity.Luggage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class LuggageRenderer
extends MobRenderer<Luggage, LuggageModel<Luggage>> {
    public LuggageRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new LuggageModel(ctx.bakeLayer(ClientEvents.LUGGAGE)), 0.5f);
        this.addLayer(new LuggagePowerLayer((RenderLayerParent<Luggage, LuggageModel<Luggage>>)this));
    }

    public ResourceLocation getTextureLocation(Luggage luggage) {
        return new ResourceLocation("luggage", "textures/entity/luggage" + (luggage.hasExtendedInventory() ? "_special" : "") + ".png");
    }

    public static class LuggagePowerLayer
    extends RenderLayer<Luggage, LuggageModel<Luggage>> {
        public LuggagePowerLayer(RenderLayerParent<Luggage, LuggageModel<Luggage>> parent) {
            super(parent);
        }

        public void render(PoseStack ms, MultiBufferSource buffer, int light, Luggage luggage, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float headYaw, float headPitch) {
            if (luggage.hasExtendedInventory()) {
                assert (Minecraft.getInstance().level != null);
                float f = (float)Minecraft.getInstance().level.getGameTime() + partialTicks;
                ((LuggageModel)this.getParentModel()).prepareMobModel((Entity)luggage, limbSwing, limbSwingAmount, partialTicks);
                VertexConsumer vertexconsumer = buffer.getBuffer(RenderType.energySwirl((ResourceLocation)new ResourceLocation("textures/entity/creeper/creeper_armor.png"), (float)(f * 0.01f % 1.0f), (float)(f * 0.01f % 1.0f)));
                ((LuggageModel)this.getParentModel()).setupAnim(luggage, limbSwing, limbSwingAmount, ageInTicks, headYaw, headPitch);
                ((LuggageModel)this.getParentModel()).renderToBuffer(ms, vertexconsumer, light, OverlayTexture.NO_OVERLAY, 0.5f, 0.5f, 0.5f, 1.0f);
            }
        }
    }
}

