/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.entity.ai.LuggageFollowOwnerGoal;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class AbstractLuggage
extends TamableAnimal {
    private int soundCooldown = 15;

    protected AbstractLuggage(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
        this.setPathfindingMalus(BlockPathTypes.LEAVES, -1.0f);
        this.setPathfindingMalus(BlockPathTypes.FENCE, -1.0f);
        this.setPathfindingMalus(BlockPathTypes.COCOA, -1.0f);
        this.setPathfindingMalus(BlockPathTypes.WATER, 0.0f);
        this.setPathfindingMalus(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new LuggageFollowOwnerGoal(this, 1.1, 7.0f, 1.0f));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 0.0).add(Attributes.MOVEMENT_SPEED, 0.35);
    }

    public void aiStep() {
        super.aiStep();
        if (this.soundCooldown > 0) {
            --this.soundCooldown;
        }
    }

    public int getSoundCooldown() {
        return this.soundCooldown;
    }

    public void setSoundCooldown(int cooldown) {
        this.soundCooldown = cooldown;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel level, AgeableMob mob) {
        return null;
    }

    public void tame(Player player) {
        this.setTame(true);
        this.setOwnerUUID(player.getUUID());
    }

    public boolean wantsToAttack(LivingEntity owner, LivingEntity target) {
        return false;
    }

    public float getStepHeight() {
        return 1.0f;
    }

    public boolean removeWhenFarAway(double dist) {
        return false;
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean isInvulnerableTo(DamageSource source) {
        return true;
    }

    public void setHealth(float health) {
    }

    public boolean onClimbable() {
        return false;
    }

    public void knockback(double x, double y, double z) {
    }

    protected void pushEntities() {
    }

    public boolean addEffect(MobEffectInstance instance, @Nullable Entity entity) {
        return false;
    }

    public boolean causeFallDamage(float dist, float mult, DamageSource source) {
        return false;
    }

    public void checkDespawn() {
    }

    public boolean canChangeDimensions() {
        return false;
    }

    public boolean attackable() {
        return false;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    protected float getWaterSlowDown() {
        return 0.9f;
    }

    public double getFluidJumpThreshold() {
        return 0.2f;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }

    public boolean canBeLeashed(Player player) {
        return false;
    }

    public boolean isIgnoringBlockTriggers() {
        return true;
    }

    public boolean isSteppingCarefully() {
        return true;
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        this.playSound((SoundEvent)LuggageRegistries.SoundRegistry.LUGGAGE_STEP.get(), 0.1f, 0.7f + this.getRandom().nextFloat() * 0.5f);
    }
}

