/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.entity.AbstractLuggage;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class EnderLuggage
extends AbstractLuggage {
    public EnderLuggage(EntityType<? extends TamableAnimal> type, Level level) {
        super(type, level);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide() && this.tickCount % 5 == 0) {
            for (int i = 0; i < 2; ++i) {
                int j = this.getRandom().nextInt(2) * 2 - 1;
                int k = this.getRandom().nextInt(2) * 2 - 1;
                double d0 = this.getX() + 0.25 * (double)j;
                double d1 = this.getY() + this.getRandom().nextDouble();
                double d2 = this.getZ() + 0.25 * (double)k;
                double d3 = this.getRandom().nextFloat() * (float)j;
                double d4 = ((double)this.getRandom().nextFloat() - 0.5) * 0.125;
                double d5 = this.getRandom().nextFloat() * (float)k;
                this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (this.isAlive()) {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(Items.NAME_TAG)) {
                return InteractionResult.PASS;
            }
            if (player.isShiftKeyDown()) {
                if (this.getOwner() == player) {
                    if (!this.level().isClientSide()) {
                        ItemStack luggageItem = new ItemStack((ItemLike)LuggageRegistries.ItemRegistry.ENDER_LUGGAGE.get());
                        if (player.getInventory().add(luggageItem)) {
                            this.discard();
                            this.playSound(SoundEvents.ITEM_PICKUP, 0.5f, this.getRandom().nextFloat() * 0.1f + 0.9f);
                        }
                    }
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                player.displayClientMessage((Component)Component.translatable((String)"entity.luggage.player_doesnt_own").withStyle(ChatFormatting.DARK_RED), true);
                return InteractionResult.CONSUME;
            }
            this.level().gameEvent((Entity)player, GameEvent.CONTAINER_OPEN, player.blockPosition());
            if (this.getSoundCooldown() == 0) {
                this.playSound(SoundEvents.ENDER_CHEST_OPEN, 0.5f, this.getRandom().nextFloat() * 0.1f + 0.9f);
                this.setSoundCooldown(5);
            }
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, cPlayer) -> ChestMenu.threeRows((int)id, (Inventory)inventory, (Container)player.getEnderChestInventory()), this.getTypeName()));
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public void remove(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.KILLED) {
            this.spawnAnim();
            this.playSound((SoundEvent)LuggageRegistries.SoundRegistry.LUGGAGE_KILLED.get(), 8.0f, 1.0f);
        }
        super.remove(reason);
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)LuggageRegistries.ItemRegistry.ENDER_LUGGAGE.get());
    }
}

