/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.entity.ai;

import com.gizmo.luggage.entity.AbstractLuggage;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class LuggageFollowOwnerGoal
extends Goal {
    private final AbstractLuggage luggage;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;
    private float oldWaterCost;

    public LuggageFollowOwnerGoal(AbstractLuggage luggage, double speed, float startDist, float stopDist) {
        this.luggage = luggage;
        this.level = luggage.level();
        this.speedModifier = speed;
        this.navigation = luggage.getNavigation();
        this.startDistance = startDist;
        this.stopDistance = stopDist;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        LivingEntity livingentity = this.luggage.getOwner();
        if (livingentity == null || livingentity.isSpectator() || livingentity.hasPose(Pose.SLEEPING)) {
            return false;
        }
        if (this.luggage.distanceToSqr((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return !(this.luggage.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.luggage.getPathfindingMalus(BlockPathTypes.WATER);
        this.luggage.setPathfindingMalus(BlockPathTypes.WATER, 0.0f);
    }

    public void stop() {
        this.owner = null;
        this.navigation.stop();
        this.luggage.setPathfindingMalus(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void tick() {
        this.luggage.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.luggage.getMaxHeadXRot());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (!this.luggage.isLeashed() && !this.luggage.isPassenger()) {
                if (this.luggage.distanceToSqr((Entity)this.owner) >= 1600.0) {
                    this.teleportToOwner();
                } else {
                    this.navigation.moveTo((Entity)this.owner, this.speedModifier);
                }
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.blockPosition();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.getX() + j, blockpos.getY() + k, blockpos.getZ() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.getX()) < 2.0 && Math.abs((double)z - this.owner.getZ()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.luggage.moveTo((double)x + 0.5, y, (double)z + 0.5, this.luggage.getYRot(), this.luggage.getXRot());
        this.navigation.stop();
        return true;
    }

    private boolean canTeleportTo(BlockPos pos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.getBlockPathTypeStatic((BlockGetter)this.level, (BlockPos.MutableBlockPos)pos.mutable());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pos.subtract((Vec3i)this.luggage.blockPosition());
        return this.level.noCollision((Entity)this.luggage, this.luggage.getBoundingBox().move(blockpos));
    }

    private int randomIntInclusive(int min, int max) {
        return this.luggage.getRandom().nextInt(max - min + 1) + min;
    }
}

