/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.item;

import com.gizmo.luggage.client.LuggageItemRenderer;
import com.gizmo.luggage.entity.AbstractLuggage;
import com.gizmo.luggage.entity.Luggage;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractLuggageItem
extends Item {
    public AbstractLuggageItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        BlockHitResult result = AbstractLuggageItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack stack = player.getItemInHand(hand);
        if (result.getType() == HitResult.Type.BLOCK) {
            AbstractLuggage entity;
            Vec3 vec = result.getLocation();
            if (!level.isClientSide() && (entity = (AbstractLuggage)this.getLuggageEntity().create(level)) != null) {
                entity.moveTo(vec);
                entity.tame(player);
                if (entity instanceof Luggage) {
                    Luggage luggage = (Luggage)entity;
                    luggage.restoreFromStack(stack);
                }
                level.addFreshEntity((Entity)entity);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public abstract EntityType<? extends AbstractLuggage> getLuggageEntity();

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot slot, Entity entity) {
        return slot == EquipmentSlot.HEAD;
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return new LuggageItemRenderer();
            }
        });
    }
}

