/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.item;

import com.gizmo.luggage.LuggageRegistries;
import com.gizmo.luggage.entity.Luggage;
import com.gizmo.luggage.item.AbstractLuggageItem;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class LuggageItem
extends AbstractLuggageItem {
    public LuggageItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        boolean insertedAny = false;
        ItemStack stack = player.getItemInHand(hand);
        BlockHitResult result = LuggageItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (result.getType() == HitResult.Type.BLOCK) {
            Vec3 blockPos = result.getLocation();
            BlockPos pos = result.getBlockPos();
            if (!level.isClientSide() && player.isSecondaryUseActive() && level.getBlockState(BlockPos.containing((Position)blockPos)).hasBlockEntity()) {
                BlockEntity be = level.getBlockEntity(result.getBlockPos());
                IItemHandler cap = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, result.getBlockPos(), level.getBlockState(pos), be, (Object)result.getDirection());
                if (cap != null) {
                    CompoundTag tag = stack.getTag();
                    SimpleContainer newInv = new SimpleContainer(tag != null && tag.contains("Extended") ? 54 : 27);
                    for (ItemStack stack1 : this.getContents(stack).toList()) {
                        for (int slot = 0; slot < cap.getSlots(); ++slot) {
                            if (cap.insertItem(slot, stack1, true) == stack1) continue;
                            stack1 = cap.insertItem(slot, stack1, false);
                            insertedAny = true;
                            break;
                        }
                        newInv.addItem(stack1);
                    }
                    if (insertedAny && tag != null) {
                        tag.put("Inventory", (Tag)newInv.createTag());
                    }
                }
            }
            return insertedAny ? InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide()) : super.use(level, player, hand);
        }
        if (result.getType() == HitResult.Type.MISS && player.isSecondaryUseActive() && this.dropContents(stack, player)) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public EntityType<Luggage> getLuggageEntity() {
        return (EntityType)LuggageRegistries.EntityRegistry.LUGGAGE.get();
    }

    private Stream<ItemStack> getContents(ItemStack stack) {
        CompoundTag compoundtag = stack.getTag();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.getList("Inventory", 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::of);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        NonNullList nonnulllist = NonNullList.create();
        this.getContents(stack).forEach(arg_0 -> nonnulllist.add(arg_0));
        return nonnulllist.isEmpty() ? Optional.empty() : Optional.of(new Tooltip((NonNullList<ItemStack>)nonnulllist, stack));
    }

    private boolean dropContents(ItemStack stack, Player player) {
        CompoundTag tag = stack.getTag();
        if (tag == null || !tag.contains("Inventory")) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listtag = tag.getList("Inventory", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag stackTag = listtag.getCompound(i);
                ItemStack itemstack = ItemStack.of((CompoundTag)stackTag);
                player.drop(itemstack, true);
            }
        }
        stack.removeTagKey("Inventory");
        return true;
    }

    public void onDestroyed(ItemEntity entity, DamageSource source) {
        ItemUtils.onContainerDestroyed((ItemEntity)entity, this.getContents(entity.getItem()));
    }

    public record Tooltip(NonNullList<ItemStack> stacks, ItemStack stack) implements TooltipComponent
    {
    }
}

