/*
 * Decompiled with CFR 0.152.
 */
package com.gizmo.luggage.network;

import com.gizmo.luggage.LuggageMenu;
import com.gizmo.luggage.client.LuggageScreen;
import com.gizmo.luggage.entity.Luggage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record OpenLuggageScreenPacket(int containerID, int entityID) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("luggage", "open_luggage_screen");

    public OpenLuggageScreenPacket(FriendlyByteBuf buf) {
        this(buf.readUnsignedByte(), buf.readInt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.containerID());
        buf.writeInt(this.entityID());
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void handle(final OpenLuggageScreenPacket message, final PlayPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.workHandler().execute(new Runnable(){

                @Override
                public void run() {
                    Level level = (Level)ctx.level().orElseThrow();
                    Entity entity = level.getEntity(message.entityID());
                    if (entity instanceof Luggage) {
                        Luggage luggage = (Luggage)entity;
                        LocalPlayer localplayer = Minecraft.getInstance().player;
                        SimpleContainer simplecontainer = new SimpleContainer(luggage.hasExtendedInventory() ? 54 : 27);
                        assert (localplayer != null);
                        LuggageMenu menu = new LuggageMenu(message.containerID(), localplayer.getInventory(), (Container)simplecontainer, luggage);
                        localplayer.containerMenu = menu;
                        Minecraft.getInstance().setScreen((Screen)new LuggageScreen(menu, localplayer.getInventory(), luggage));
                    }
                }
            });
        }
    }
}

