/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.smileycorp.atlas.api.entity.AtlasBoat;
import net.smileycorp.atlas.api.item.AtlasBoatItem;
import net.smileycorp.atlas.common.AtlasLib;

public class BoatRegistry {
    private Map<ResourceLocation, Type> TYPES = new HashMap<ResourceLocation, Type>();
    public static BoatRegistry INSTANCE = new BoatRegistry();
    public static RegistryObject<EntityType<AtlasBoat>> BOAT_ENTITY;

    public Type register(String name, String modid, DeferredRegister<Item> register, CreativeModeTab creativeTab) {
        if (this.TYPES.isEmpty()) {
            BOAT_ENTITY = AtlasLib.ENTITIES.register("atlas_boat", () -> EntityType.Builder.m_20704_(AtlasBoat::new, (MobCategory)MobCategory.MISC).m_20699_(1.375f, 0.5625f).m_20702_(10).m_20712_("atlas_boat"));
        }
        Type type = new Type(name, modid, register, creativeTab);
        this.TYPES.put(type.getRegistryName(), type);
        return type;
    }

    public Type get(ResourceLocation loc) {
        return this.TYPES.get(loc);
    }

    public Type get(String name, String modid) {
        return this.get(new ResourceLocation(modid, name));
    }

    public static class Type {
        private final String name;
        private final String modid;
        private final RegistryObject<Item> boat;

        protected Type(String name, String modid, DeferredRegister<Item> register, CreativeModeTab creativeTab) {
            this.name = name;
            this.modid = modid;
            this.boat = register.register(name + "_boat", () -> new AtlasBoatItem(this, new Item.Properties().m_41491_(creativeTab)));
        }

        public String getName() {
            return this.name;
        }

        public String getModid() {
            return this.modid;
        }

        public Item getItem() {
            return (Item)this.boat.get();
        }

        public ResourceLocation getRegistryName() {
            return new ResourceLocation(this.modid, this.name);
        }
    }
}

