/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;

public class AtlasFluid {
    private final String name;
    private RegistryObject<Fluid> source;
    private RegistryObject<Fluid> flowing;
    private RegistryObject<Block> block;
    private RegistryObject<Item> bucket;

    public AtlasFluid(String modid, String name, DeferredRegister<Fluid> fluids, DeferredRegister<Block> blocks, DeferredRegister<Item> items, BlockBehaviour.Properties properties, CreativeModeTab tab) {
        this.name = name;
        this.source = this.register(fluids, () -> new ForgeFlowingFluid.Source(new ForgeFlowingFluid.Properties(() -> (Fluid)this.source.get(), this.flowing, FluidAttributes.builder((ResourceLocation)new ResourceLocation(modid, "fluid/" + name), (ResourceLocation)new ResourceLocation(modid, "fluid/" + name + "_flowing"))).bucket(this.bucket).block(() -> (LiquidBlock)this.block.get()).levelDecreasePerBlock(3)), "");
        this.flowing = this.register(fluids, () -> new ForgeFlowingFluid.Flowing(new ForgeFlowingFluid.Properties(() -> (Fluid)this.source.get(), this.flowing, FluidAttributes.builder((ResourceLocation)new ResourceLocation(modid, "fluid/" + name), (ResourceLocation)new ResourceLocation(modid, "fluid/" + name + "_flowing"))).bucket(this.bucket).block(() -> (LiquidBlock)this.block.get()).levelDecreasePerBlock(3)), "flowing", "");
        this.block = this.register(blocks, () -> new LiquidBlock(() -> (FlowingFluid)this.source.get(), properties), "");
        this.bucket = this.register(items, () -> new BucketItem(this.source, new Item.Properties().m_41495_(Items.f_42446_).m_41487_(1).m_41491_(tab)), "bucket");
    }

    protected <T extends IForgeRegistryEntry<T>> RegistryObject<T> register(DeferredRegister<T> registry, Supplier<T> supplier, String suffix) {
        return this.register(registry, supplier, "", suffix);
    }

    protected <T extends IForgeRegistryEntry<T>> RegistryObject<T> register(DeferredRegister<T> registry, Supplier<T> supplier, String prefix, String suffix) {
        StringBuilder builder = new StringBuilder();
        if (!prefix.isBlank()) {
            builder.append(prefix + "_");
        }
        builder.append(this.name.toLowerCase());
        if (!suffix.isBlank()) {
            builder.append("_" + suffix);
        }
        return registry.register(builder.toString(), supplier);
    }

    public Fluid getSource() {
        return (Fluid)this.source.get();
    }

    public Fluid getFlowing() {
        return (Fluid)this.flowing.get();
    }

    public Block getBlock() {
        return (Block)this.block.get();
    }

    public Item getBucket() {
        return (Item)this.bucket.get();
    }
}

