/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WoodButtonBlock;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.smileycorp.atlas.api.BoatRegistry;
import net.smileycorp.atlas.api.block.BlockUtils;
import net.smileycorp.atlas.api.block.FuelHandler;
import net.smileycorp.atlas.api.block.WoodBlockBuilder;
import net.smileycorp.atlas.api.client.entity.AtlasBoatRenderer;
import net.smileycorp.atlas.api.item.AtlasBoatItem;

public class WoodBlock {
    protected final String name;
    protected final boolean isFlammable;
    protected final CreativeModeTab tab;
    protected final CreativeModeTab decorations_tab;
    protected final TagKey<Item> logs_item_tag;
    protected final TagKey<Block> logs_block_tag;
    protected final AbstractTreeGrower tree_grower;
    protected final WoodType sign_type;
    protected final BoatRegistry.Type boat_type;
    protected final Map<WoodShape, RegistryObject<Block>> BLOCKS = Maps.newHashMap();
    protected final Optional<RegistryObject<Item>> sign;

    protected WoodBlock(WoodBlockBuilder builder, DeferredRegister<Item> items, DeferredRegister<Block> blocks) {
        this.name = builder.name;
        this.isFlammable = builder.is_flammable;
        this.tab = builder.tab;
        this.decorations_tab = builder.decorations_tab;
        this.logs_item_tag = ItemTags.create((ResourceLocation)new ResourceLocation(items.getRegistryName().m_135827_(), this.name + "_logs"));
        this.logs_block_tag = BlockTags.create((ResourceLocation)new ResourceLocation(blocks.getRegistryName().m_135827_(), this.name + "_logs"));
        this.tree_grower = builder.tree_grower;
        this.sign_type = WoodType.m_61844_((WoodType)WoodType.create((String)this.name));
        this.register(items, blocks, () -> new Block(builder.constructBaseProperties()), WoodShape.PLANKS);
        this.register(items, blocks, () -> new StairBlock(this.get(WoodShape.PLANKS).m_49966_(), builder.constructBaseProperties()), WoodShape.STAIRS);
        this.register(items, blocks, () -> new SlabBlock(builder.constructBaseProperties()), WoodShape.SLAB);
        this.register(items, blocks, () -> new RotatedPillarBlock(builder.constructBaseProperties()), WoodShape.STRIPPED_LOG);
        this.register(items, blocks, () -> new RotatedPillarBlock(builder.constructBaseProperties()), WoodShape.STRIPPED_WOOD);
        this.register(items, blocks, () -> new RotatedPillarBlock(builder.constructLogProperties()){

            public BlockState getToolModifiedState(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, ToolAction tool) {
                return tool == ToolActions.AXE_STRIP ? (BlockState)WoodBlock.this.get(WoodShape.STRIPPED_LOG).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)((Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_))) : null;
            }
        }, WoodShape.LOG);
        this.register(items, blocks, () -> new RotatedPillarBlock(builder.constructPropertiesFrom(BlockBehaviour.Properties.m_60944_((Material)builder.wood_material, (MaterialColor)builder.bark_colour))){

            public BlockState getToolModifiedState(BlockState state, Level world, BlockPos pos, Player player, ItemStack stack, ToolAction tool) {
                return tool == ToolActions.AXE_STRIP ? WoodBlock.this.get(WoodShape.STRIPPED_WOOD).m_49966_() : null;
            }
        }, WoodShape.WOOD);
        this.register(items, blocks, () -> new LeavesBlock(BlockBehaviour.Properties.m_60944_((Material)builder.leaves_material, (MaterialColor)builder.leaves_colour).m_60978_(0.2f).m_60977_().m_60918_(builder.leaves_sound).m_60955_().m_60922_(BlockUtils::jungleMob).m_60960_(BlockUtils::never).m_60971_(BlockUtils::never)), WoodShape.LEAVES);
        if (builder.tree_grower != null) {
            this.register(items, blocks, () -> new SaplingBlock(builder.tree_grower, BlockBehaviour.Properties.m_60939_((Material)Material.f_76300_).m_60910_().m_60955_().m_60977_().m_60966_().m_60918_(SoundType.f_56740_)), WoodShape.SAPLING);
        }
        this.register(items, blocks, () -> new FenceBlock(builder.constructBaseProperties()), WoodShape.FENCE);
        this.register(items, blocks, () -> new FenceGateBlock(builder.constructBaseProperties()), WoodShape.FENCE_GATE);
        this.register(items, blocks, () -> new WoodButtonBlock(builder.constructBaseProperties()), WoodShape.BUTTON);
        this.register(items, blocks, () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, builder.constructBaseProperties()), WoodShape.PRESSURE_PLATE);
        this.register(items, blocks, () -> new DoorBlock(builder.constructBaseProperties().m_60955_()), WoodShape.DOOR);
        this.register(items, blocks, () -> new TrapDoorBlock(builder.constructBaseProperties().m_60955_()), WoodShape.TRAPDOOR);
        this.register(blocks, () -> new StandingSignBlock(builder.constructBaseProperties(), this.sign_type), WoodShape.SIGN);
        this.register(blocks, () -> new WallSignBlock(builder.constructBaseProperties(), this.sign_type), WoodShape.WALL_SIGN);
        this.sign = Optional.of(items.register(WoodShape.SIGN.getName(this.name), () -> new SignItem(new Item.Properties().m_41487_(16).m_41491_(builder.decorations_tab), this.get(WoodShape.SIGN), this.get(WoodShape.WALL_SIGN))));
        this.boat_type = builder.has_boat ? BoatRegistry.INSTANCE.register(this.name, builder.modid, items, builder.decorations_tab) : null;
    }

    protected void registerItem(DeferredRegister<Item> items, RegistryObject<Block> block, CreativeModeTab tab) {
        items.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(tab)));
    }

    protected void register(DeferredRegister<Block> blocks, Supplier<Block> supplier, WoodShape shape) {
        RegistryObject block = blocks.register(shape.getName(this.name), supplier);
        this.BLOCKS.put(shape, (RegistryObject<Block>)block);
    }

    protected void register(DeferredRegister<Item> items, DeferredRegister<Block> blocks, Supplier<Block> supplier, WoodShape shape) {
        RegistryObject block = blocks.register(shape.getName(this.name), supplier);
        this.BLOCKS.put(shape, (RegistryObject<Block>)block);
        items.register(shape.getName(this.name), () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(shape.getTab(this))));
    }

    public Block get(WoodShape shape) {
        return this.BLOCKS.containsKey((Object)shape) ? (Block)this.BLOCKS.get((Object)shape).get() : null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFlammable() {
        return this.isFlammable;
    }

    public TagKey<Item> getLogItemTag() {
        return this.logs_item_tag;
    }

    public TagKey<Block> getLogBlockTag() {
        return this.logs_block_tag;
    }

    public AbstractTreeGrower getTreeGrower() {
        return this.tree_grower;
    }

    public WoodType getSignType() {
        return this.sign_type;
    }

    public Block getPlanks() {
        return this.get(WoodShape.PLANKS);
    }

    public StairBlock getStairs() {
        return (StairBlock)this.get(WoodShape.STAIRS);
    }

    public SlabBlock getSlab() {
        return (SlabBlock)this.get(WoodShape.SLAB);
    }

    public RotatedPillarBlock getLog() {
        return (RotatedPillarBlock)this.get(WoodShape.LOG);
    }

    public RotatedPillarBlock getStrippedLog() {
        return (RotatedPillarBlock)this.get(WoodShape.STRIPPED_LOG);
    }

    public RotatedPillarBlock getWood() {
        return (RotatedPillarBlock)this.get(WoodShape.WOOD);
    }

    public RotatedPillarBlock getStrippedWood() {
        return (RotatedPillarBlock)this.get(WoodShape.STRIPPED_WOOD);
    }

    public LeavesBlock getLeaves() {
        return (LeavesBlock)this.get(WoodShape.LEAVES);
    }

    public SaplingBlock getSapling() {
        return (SaplingBlock)this.get(WoodShape.SAPLING);
    }

    public FenceBlock getFence() {
        return (FenceBlock)this.get(WoodShape.FENCE);
    }

    public FenceGateBlock getFenceGate() {
        return (FenceGateBlock)this.get(WoodShape.FENCE_GATE);
    }

    public ButtonBlock getButton() {
        return (ButtonBlock)this.get(WoodShape.BUTTON);
    }

    public PressurePlateBlock getPressurePlate() {
        return (PressurePlateBlock)this.get(WoodShape.PRESSURE_PLATE);
    }

    public DoorBlock getDoor() {
        return (DoorBlock)this.get(WoodShape.DOOR);
    }

    public TrapDoorBlock getTrapdoor() {
        return (TrapDoorBlock)this.get(WoodShape.TRAPDOOR);
    }

    public SignBlock getSignBlock(boolean onWall) {
        return (SignBlock)(onWall ? this.get(WoodShape.WALL_SIGN) : this.get(WoodShape.SIGN));
    }

    public SignItem getSignItem() {
        return (SignItem)this.sign.get().orElse(null);
    }

    public AtlasBoatItem getBoat() {
        return (AtlasBoatItem)this.boat_type.getItem();
    }

    public void registerClient() {
        Sheets.addWoodType((WoodType)this.sign_type);
        ItemBlockRenderTypes.setRenderLayer((Block)this.getDoor(), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)this.getTrapdoor(), (RenderType)RenderType.m_110457_());
        ItemBlockRenderTypes.setRenderLayer((Block)this.getSapling(), (RenderType)RenderType.m_110457_());
        if (this.boat_type != null && !AtlasBoatRenderer.isRegistered()) {
            AtlasBoatRenderer.register();
        }
    }

    public void registerStandardFuelValues() {
        FuelHandler.INSTANCE.registerFuel(this.getPlanks(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getStairs(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getSlab(), 150);
        FuelHandler.INSTANCE.registerFuel((Block)this.getLog(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getStrippedLog(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getWood(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getStrippedWood(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getSapling(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getFence(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getFenceGate(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getButton(), 100);
        FuelHandler.INSTANCE.registerFuel((Block)this.getPressurePlate(), 300);
        FuelHandler.INSTANCE.registerFuel((Block)this.getDoor(), 200);
        FuelHandler.INSTANCE.registerFuel((Block)this.getTrapdoor(), 300);
        FuelHandler.INSTANCE.registerFuel((Item)this.getSignItem(), 200);
    }

    public static enum WoodShape {
        PLANKS("planks"),
        STAIRS("stairs"),
        SLAB("slab"),
        STRIPPED_LOG("stripped", "log"),
        STRIPPED_WOOD("stripped", "wood"),
        LOG("log"),
        WOOD("wood"),
        LEAVES("", "leaves", true),
        SAPLING("", "sapling", true),
        FENCE("", "fence", true),
        FENCE_GATE("", "fence_gate", true),
        BUTTON("", "button", true),
        PRESSURE_PLATE("", "pressure_plate", true),
        DOOR("", "door", true),
        TRAPDOOR("", "trapdoor", true),
        SIGN("sign"),
        WALL_SIGN("wall_sign");

        private final String suffix;
        private final String prefix;
        private final boolean is_decoration;

        private WoodShape(String suffix) {
            this("", suffix);
        }

        private WoodShape(String prefix, String suffix) {
            this(prefix, suffix, false);
        }

        private WoodShape(String prefix, String suffix, boolean isDecoration) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.is_decoration = isDecoration;
        }

        public String getName(String name) {
            StringBuilder builder = new StringBuilder();
            if (!this.prefix.isBlank()) {
                builder.append(this.prefix + "_");
            }
            builder.append(name.toLowerCase());
            if (!(this.suffix.isBlank() || name.contains("wood") && this.suffix.equals("wood"))) {
                builder.append("_" + this.suffix);
            }
            return builder.toString();
        }

        public CreativeModeTab getTab(WoodBlock wood_block) {
            return this.is_decoration ? wood_block.decorations_tab : wood_block.tab;
        }
    }
}

