/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.Lists;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector3f;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.smileycorp.atlas.api.client.PlanarQuadRenderer;
import net.smileycorp.atlas.api.client.PlayerTextureRenderer;

public class RenderingUtils {
    public static List<BakedModel> replaceRegisteredModel(Map<ResourceLocation, BakedModel> map, ResourceLocation name, Function<BakedModel, BakedModel> function) {
        ArrayList models = Lists.newArrayList();
        for (Map.Entry<ResourceLocation, BakedModel> entry : map.entrySet()) {
            ResourceLocation loc = entry.getKey();
            if (!loc.m_135827_().equals(name.m_135827_()) || !loc.m_135815_().split("#")[0].equals(name.m_135815_())) continue;
            models.add(function.apply(entry.getValue()));
        }
        BakedModel model = function.apply(map.get(name));
        map.put(name, model);
        return models;
    }

    public static void renderCubeQuad(BufferBuilder buffer, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            RenderingUtils.renderPlanarQuad(buffer, facing, x, y, z, layer, colour, texture, world, luminance, pos);
        }
    }

    public static void renderPlanarQuad(BufferBuilder buffer, Direction facing, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        Vector3f[] plane = PlanarQuadRenderer.getQuadsFor(facing);
        Vector3f offset = layer == 0 ? new Vector3f(0.0f, 0.0f, 0.0f) : PlanarQuadRenderer.getOffsetFor(facing, x, y, z, layer);
        int rgba = colour.getRGB();
        for (int i = 0; i < 4; ++i) {
            Vector3f quadPos = plane[i];
            float r = (float)((rgba & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((rgba & 0xFF00) >> 8) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)((rgba & 0xFF000000) >> 24) / 255.0f;
            float u = i < 2 ? texture.m_118410_() - 6.25E-6f : texture.m_118409_() + 6.25E-6f;
            float v = i == 1 || i == 2 ? texture.m_118412_() - 6.25E-6f : texture.m_118411_() + 6.25E-6f;
            buffer.m_5483_((double)(quadPos.m_122239_() + offset.m_122239_()), (double)(quadPos.m_122260_() + offset.m_122260_()), (double)(quadPos.m_122269_() + offset.m_122269_())).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
        }
    }

    public static List<BakedQuad> getQuadsForCube(Color colour, TextureAtlasSprite sprite) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (Direction facing : Direction.values()) {
            quads.addAll(RenderingUtils.getQuadsForPlane(facing, colour, sprite));
        }
        return quads;
    }

    public static List<BakedQuad> getQuadsForPlane(Direction facing, Color colour, TextureAtlasSprite sprite) {
        return RenderingUtils.getQuadsForPlane(facing, colour, sprite, 0);
    }

    public static List<BakedQuad> getQuadsForPlane(Direction facing, Color colour, TextureAtlasSprite sprite, int layer) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        Vector3f[] vecs = PlanarQuadRenderer.getQuadsFor(facing);
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = PlanarQuadRenderer.getOffsetFor(facing, vecs[i], layer);
        }
        BakedQuadBuilder builder = new BakedQuadBuilder(sprite);
        builder.setQuadOrientation(facing);
        Vector3f normal = new Vector3f(vecs[2].m_122239_() - vecs[1].m_122239_(), vecs[2].m_122260_() - vecs[1].m_122260_(), vecs[2].m_122269_() - vecs[1].m_122269_());
        normal.m_122279_(new Vector3f(vecs[0].m_122239_() - vecs[1].m_122239_(), vecs[0].m_122260_() - vecs[1].m_122260_(), vecs[0].m_122269_() - vecs[1].m_122269_()));
        normal.m_122278_();
        RenderingUtils.addVertex(builder, vecs[0].m_122239_(), vecs[0].m_122260_(), vecs[0].m_122269_(), 0.0f, 0.0f, normal, colour, sprite);
        RenderingUtils.addVertex(builder, vecs[1].m_122239_(), vecs[1].m_122260_(), vecs[1].m_122269_(), 0.0f, sprite.m_118408_(), normal, colour, sprite);
        RenderingUtils.addVertex(builder, vecs[2].m_122239_(), vecs[2].m_122260_(), vecs[2].m_122269_(), sprite.m_118405_(), sprite.m_118408_(), normal, colour, sprite);
        RenderingUtils.addVertex(builder, vecs[3].m_122239_(), vecs[3].m_122260_(), vecs[3].m_122269_(), sprite.m_118405_(), 0.0f, normal, colour, sprite);
        quads.add(builder.build());
        return quads;
    }

    private static void addVertex(BakedQuadBuilder builder, float x, float y, float z, float u, float v, Vector3f normal, Color colour, TextureAtlasSprite sprite) {
        block10: for (int i = 0; i < builder.getVertexFormat().m_86023_().size(); ++i) {
            VertexFormatElement element = (VertexFormatElement)builder.getVertexFormat().m_86023_().get(i);
            switch (element.m_86048_()) {
                case POSITION: {
                    builder.put(i, new float[]{x, y, z, 1.0f});
                    continue block10;
                }
                case COLOR: {
                    builder.put(i, new float[]{(float)colour.getRed() / 255.0f, (float)colour.getGreen() / 255.0f, (float)colour.getBlue() / 255.0f, 1.0f});
                    continue block10;
                }
                case UV: {
                    switch (element.m_86049_()) {
                        case 0: {
                            builder.put(i, new float[]{sprite.m_118367_((double)u), sprite.m_118393_((double)v)});
                            continue block10;
                        }
                        case 2: {
                            builder.put(i, new float[]{0.0f});
                            continue block10;
                        }
                    }
                    builder.put(i, new float[0]);
                    continue block10;
                }
                case NORMAL: {
                    builder.put(i, new float[]{normal.m_122239_(), normal.m_122260_(), normal.m_122269_()});
                    continue block10;
                }
                default: {
                    builder.put(i, new float[0]);
                }
            }
        }
    }

    @Deprecated
    public static ResourceLocation getPlayerTexture(Optional<UUID> uuid, MinecraftProfileTexture.Type type) {
        return PlayerTextureRenderer.getTexture(uuid, type);
    }

    @Deprecated
    public static String getSkinType(Optional<UUID> uuid) {
        return PlayerTextureRenderer.getSkinType(uuid);
    }
}

