/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.smileycorp.hordes.client.ClientHandler;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.MiscEventHandler;
import net.smileycorp.hordes.common.data.DataGenerator;
import net.smileycorp.hordes.common.data.DataRegistry;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.config.ClientConfigHandler;
import net.smileycorp.hordes.config.CommonConfigHandler;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.hordeevent.HordeEventHandler;
import net.smileycorp.hordes.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.InfectionEventHandler;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;

@Mod(value="hordes")
@Mod.EventBusSubscriber(modid="hordes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Hordes {
    public Hordes() {
        HordesLogger.clearLog();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfigHandler.config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfigHandler.config);
        if (DataGenerator.shouldGenerateFiles()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> DataGenerator::generateAssets);
            DataGenerator.generateData();
        } else {
            HordesLogger.logInfo("Config files are up to date, skipping data/asset generation");
        }
    }

    @SubscribeEvent
    public static void addPacks(AddPackFindersEvent event) {
        Path path = FMLPaths.CONFIGDIR.get().resolve("hordes");
        event.addRepositorySource((consumer, constructor) -> consumer.accept(constructor.create(path.toString(), (Component)new TextComponent("Hordes Config"), true, () -> new FolderPackResources(path.toFile()), new PackMetadataSection((Component)new TextComponent("Hordes Config"), 8), Pack.Position.TOP, PackSource.f_10528_, false)));
    }

    @SubscribeEvent
    public static void constructMod(FMLConstructModEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new MiscEventHandler());
        HordesInfection.EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        HordesEntities.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        DataRegistry.init();
        if (((Boolean)HordeEventConfig.enableHordeEvent.get()).booleanValue()) {
            HordeEventPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new HordeEventHandler());
        }
        if (((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue()) {
            InfectionPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new InfectionEventHandler());
        }
    }

    @SubscribeEvent
    public static void loadClient(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
    }
}

