/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import com.google.common.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HordesLogger {
    private static Logger logger = LogManager.getLogger((String)"hordes");
    private static boolean has_errors;
    private static Path log_file;

    public static void clearLog() {
        try {
            Files.write(log_file, (Iterable<? extends CharSequence>)Lists.newArrayList(), StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (Exception e) {
            logger.error("Failed to write to log file", (Throwable)e);
            e.printStackTrace();
        }
    }

    public static void logSilently(Object message) {
        HordesLogger.writeToFile(message);
    }

    public static void logInfo(Object message) {
        HordesLogger.writeToFile(message);
        logger.info(message);
    }

    public static void logError(Object message, Exception e) {
        HordesLogger.writeToFile(message + " " + e);
        for (StackTraceElement traceElement : e.getStackTrace()) {
            HordesLogger.writeToFile(traceElement);
        }
        logger.error(message, (Throwable)e);
        e.printStackTrace();
        has_errors = true;
    }

    public static boolean logSaveData(HordeSavedData data) {
        HordesLogger.writeToFile("Horde world data: ");
        return HordesLogger.writeToFile(data.getDebugText());
    }

    private static boolean writeToFile(Object message) {
        return HordesLogger.writeToFile(Lists.newArrayList((Object[])new String[]{String.valueOf(message)}));
    }

    private static boolean writeToFile(List<String> out) {
        try {
            Files.write(log_file, out, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            return true;
        }
        catch (Exception e) {
            logger.error("Failed to write to log file", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    public static boolean hasErrors() {
        return has_errors;
    }

    public static MutableComponent getFiletext() {
        String file = log_file.toAbsolutePath().toString();
        TextComponent text = new TextComponent(file);
        text.m_6270_(Style.f_131099_.m_131162_(Boolean.valueOf(true)).m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, file)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent(file))));
        return text;
    }

    public void clearErrors() {
        has_errors = false;
    }

    static {
        log_file = Paths.get("logs/hordes.log", new String[0]);
    }
}

