/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.capability;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.smileycorp.hordes.common.capability.HordesCapabilities;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.common.event.SpawnZombiePlayerEvent;

public interface ZombifyPlayer {
    public PlayerZombie createZombie(Player var1);

    public PlayerZombie getZombie();

    public void clearZombie();

    public boolean wasZombified();

    public static class Provider
    implements ICapabilityProvider {
        protected final ZombifyPlayer impl = new Impl();

        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            return capability == HordesCapabilities.ZOMBIFY_PLAYER ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }
    }

    public static class Impl
    implements ZombifyPlayer {
        private PlayerZombie zombie = null;

        @Override
        public PlayerZombie createZombie(Player player) {
            HordesEntities.ZOMBIE_PLAYER.get();
            SpawnZombiePlayerEvent event = new SpawnZombiePlayerEvent(player, (EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.ZOMBIE_PLAYER.get()));
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return null;
            }
            EntityType<? extends PlayerZombie> type = event.getEntityType();
            this.zombie = (PlayerZombie)type.m_20615_(player.f_19853_);
            this.zombie.setPlayer(player);
            this.zombie.asEntity().m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            ((Mob)this.zombie.asEntity()).f_20884_ = player.f_20884_;
            return this.zombie;
        }

        @Override
        public PlayerZombie getZombie() {
            return this.zombie;
        }

        @Override
        public void clearZombie() {
            this.zombie = null;
        }

        @Override
        public boolean wasZombified() {
            return this.zombie != null;
        }
    }
}

