/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import net.smileycorp.atlas.api.data.DataType;

public class BinaryOperation<T extends Number> {
    private static final Map<String, BinaryOperation> registry = Maps.newHashMap();
    public static final BinaryOperation ADD = BinaryOperation.register("add", "+", DataType.DOUBLE, (a, b) -> a + b);
    public static final BinaryOperation MINUS = BinaryOperation.register("minus", "-", DataType.DOUBLE, (a, b) -> a - b);
    public static final BinaryOperation DIVIDE = BinaryOperation.register("divide", "/", DataType.DOUBLE, (a, b) -> a / b);
    public static final BinaryOperation MULTIPLY = BinaryOperation.register("multiply", "*", DataType.DOUBLE, (a, b) -> a * b);
    public static final BinaryOperation MOD = BinaryOperation.register("mod", "%", DataType.DOUBLE, (a, b) -> a % b);
    public static final BinaryOperation POW = BinaryOperation.register("power", "pow", DataType.DOUBLE, Math::pow);
    public static final BinaryOperation BITWISE_AND = BinaryOperation.register("bitwise_and", "&", DataType.INT, (a, b) -> a & b);
    public static final BinaryOperation BITWISE_OR = BinaryOperation.register("bitwise_or", "|", DataType.INT, (a, b) -> a | b);
    public static final BinaryOperation BITWISE_XOR = BinaryOperation.register("bitwise_xor", "^", DataType.INT, (a, b) -> a ^ b);
    public static final BinaryOperation LEFT_SHIFT = BinaryOperation.register("left_shift", "<<", DataType.INT, (a, b) -> a << b);
    public static final BinaryOperation RIGHT_SHIFT = BinaryOperation.register("right_shift", ">>", DataType.INT, (a, b) -> a >> b);
    public static final BinaryOperation UNSIGNED_RIGHT_SHIFT = BinaryOperation.register("unsigned_right_shift", ">>>", DataType.INT, (a, b) -> a >>> b);
    private final String name;
    private final String symbol;
    private final DataType<T> type;
    private final BiFunction<T, T, T> function;

    private BinaryOperation(String name, String symbol, DataType<T> type, BiFunction<T, T, T> function) {
        this.name = name;
        this.symbol = symbol;
        this.type = type;
        this.function = function;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public T apply(Comparable a, Comparable b) {
        return (T)((Number)this.function.apply((Number)((Object)this.type.cast(a)), (Number)((Object)this.type.cast(b))));
    }

    private static <T extends Number> BinaryOperation register(String name, String symbol, DataType<T> type, BiFunction<T, T, T> function) {
        BinaryOperation<T> operation = new BinaryOperation<T>(name, symbol, type, function);
        return registry.put(symbol, operation);
    }

    public static BinaryOperation of(String symbol) {
        if (registry.containsKey(symbol)) {
            return registry.get(symbol);
        }
        return null;
    }

    public static Collection<BinaryOperation> values() {
        return registry.values();
    }
}

