/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.smileycorp.hordes.common.HordesLogger;
import org.apache.commons.io.FileUtils;

public class DataGenerator {
    private static final Path CONFIG_FOLDER = FMLPaths.CONFIGDIR.get().resolve("hordes");

    public static boolean shouldGenerateFiles() {
        if (DataGenerator.isUpToDate()) {
            return false;
        }
        try {
            if (CONFIG_FOLDER.toFile().exists()) {
                File backup = FMLPaths.CONFIGDIR.get().resolve("hordes-backup").toFile();
                backup.mkdir();
                FileUtils.deleteDirectory((File)backup);
                FileUtils.copyDirectory((File)CONFIG_FOLDER.toFile(), (File)backup);
                HordesLogger.logInfo("Backed up old data to " + backup);
            }
            FileUtils.deleteDirectory((File)CONFIG_FOLDER.toFile());
        }
        catch (Exception backup) {
            // empty catch block
        }
        ModFile mod = FMLLoader.getLoadingModList().getModFileById("hordes").getFile();
        DataGenerator.copyFileFromMod(mod.findResource(new String[]{"config_defaults/hordes-info.json"}));
        DataGenerator.copyFileFromMod(mod.findResource(new String[]{"config_defaults/pack.mcmeta"}));
        return true;
    }

    public static void generateAssets() {
        ModFile mod = FMLLoader.getLoadingModList().getModFileById("hordes").getFile();
        try {
            Files.find(mod.findResource(new String[]{"config_defaults/assets"}), Integer.MAX_VALUE, (matcher, options) -> options.isRegularFile(), new FileVisitOption[0]).forEach(DataGenerator::copyFileFromMod);
            HordesLogger.logInfo("Generated asset files.");
        }
        catch (Exception e) {
            HordesLogger.logInfo("Failed to generate asset files.");
        }
    }

    public static void generateData() {
        ModFile mod = FMLLoader.getLoadingModList().getModFileById("hordes").getFile();
        try {
            Files.find(mod.findResource(new String[]{"config_defaults/data"}), Integer.MAX_VALUE, (matcher, options) -> options.isRegularFile(), new FileVisitOption[0]).forEach(DataGenerator::copyFileFromMod);
            HordesLogger.logInfo("Generated data files.");
        }
        catch (Exception e) {
            HordesLogger.logInfo("Failed to generate data files.");
        }
    }

    private static boolean isUpToDate() {
        File config_file = CONFIG_FOLDER.resolve("hordes-info.json").toFile();
        if (!config_file.isFile()) {
            HordesLogger.logInfo("Hordes data does not exist, generating new files.");
            return false;
        }
        try {
            boolean flag;
            JsonObject config_json = JsonParser.parseReader((Reader)new FileReader(config_file)).getAsJsonObject();
            if (config_json.get("data_version").getAsInt() < 0) {
                return true;
            }
            JsonObject mod_json = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(Files.newInputStream(FMLLoader.getLoadingModList().getModFileById("hordes").getFile().findResource(new String[]{"config_defaults/hordes-info.json"}), new OpenOption[0])))).getAsJsonObject();
            boolean bl = flag = config_json.get("data_version").getAsInt() >= mod_json.get("data_version").getAsInt();
            if (!flag) {
                HordesLogger.logInfo("Hordes data is not up to date, or set to pack author mode, generating new files.");
            }
            return flag;
        }
        catch (Exception e) {
            HordesLogger.logError("Failed data version check", e);
            return false;
        }
    }

    private static void copyFileFromMod(Path path) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)Files.newInputStream(path, new OpenOption[0]), (File)new File(CONFIG_FOLDER.toFile(), path.toString().replace("config_defaults/", "")));
            HordesLogger.logInfo("Copied file " + path);
        }
        catch (Exception e) {
            HordesLogger.logError("Failed to copy file " + path, e);
        }
    }
}

