/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.conditions;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.conditions.Condition;

public class BiomeCondition
implements Condition {
    protected final List<Either<TagKey<Biome>, ResourceLocation>> biomes;

    public BiomeCondition(List<Either<TagKey<Biome>, ResourceLocation>> biomes) {
        this.biomes = biomes;
    }

    @Override
    public boolean apply(Level level, LivingEntity entity, ServerPlayer player, Random rand) {
        Holder biome = level.m_7062_().m_204214_(player.m_142538_());
        for (Either<TagKey<Biome>, ResourceLocation> either : this.biomes) {
            if (!((Boolean)either.map(arg_0 -> ((Holder)biome).containsTag(arg_0), arg_0 -> ((Holder)biome).m_203373_(arg_0))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static BiomeCondition deserialize(JsonElement json) {
        try {
            if (json.isJsonArray()) {
                ArrayList biomes = Lists.newArrayList();
                for (JsonElement element : json.getAsJsonArray()) {
                    biomes.add(BiomeCondition.either(element.getAsString()));
                }
                return new BiomeCondition(biomes);
            }
            return new BiomeCondition(Lists.newArrayList((Object[])new Either[]{BiomeCondition.either(json.getAsString())}));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition hordes:biome", e);
            return null;
        }
    }

    private static Either<TagKey<Biome>, ResourceLocation> either(String string) {
        return string.contains("#") ? Either.left((Object)TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(string.replace("#", "")))) : Either.right((Object)new ResourceLocation(string));
    }
}

