/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.conditions;

import com.google.gson.JsonElement;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.conditions.Condition;
import net.smileycorp.hordes.common.data.values.ValueGetter;
import net.smileycorp.hordes.config.HordeEventConfig;

public class DayCondition
implements Condition {
    protected ValueGetter<Integer> day;

    public DayCondition(ValueGetter<Integer> day) {
        this.day = day;
    }

    @Override
    public boolean apply(Level level, LivingEntity entity, ServerPlayer player, Random rand) {
        return (float)level.m_46468_() / (float)((Integer)HordeEventConfig.dayLength.get()).intValue() > (float)this.day.get(level, entity, player, rand).intValue();
    }

    public static DayCondition deserialize(JsonElement json) {
        try {
            return new DayCondition(ValueGetter.readValue(DataType.INT, json));
        }
        catch (Exception e) {
            HordesLogger.logError("Incorrect parameters for condition hordes:day", e);
            return null;
        }
    }
}

