/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.values;

import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.BinaryOperation;
import net.smileycorp.hordes.common.data.values.ValueGetter;

public class BinaryOperationValueGetter<T extends Number>
implements ValueGetter<T> {
    private final BinaryOperation operation;
    private final ValueGetter<T> value1;
    private final ValueGetter<T> value2;

    private BinaryOperationValueGetter(BinaryOperation operation, ValueGetter<T> value1, ValueGetter<T> value2) {
        this.operation = operation;
        this.value1 = value1;
        this.value2 = value2;
    }

    @Override
    public T get(Level level, LivingEntity entity, ServerPlayer player, Random rand) {
        return this.operation.apply((Comparable)this.value1.get(level, entity, player, rand), (Comparable)this.value2.get(level, entity, player, rand));
    }

    public static <T extends Number> BinaryOperationValueGetter deserialize(BinaryOperation operation, DataType<T> type, JsonObject element) {
        ValueGetter<T> getter1 = ValueGetter.readValue(type, element.get("value1"));
        ValueGetter<T> getter2 = ValueGetter.readValue(type, element.get("value2"));
        if (getter1 == null || getter2 == null | type.isNumber() == false) {
            HordesLogger.logError("invalid values for hordes:" + operation.getName(), new NullPointerException());
            return null;
        }
        return new BinaryOperationValueGetter<T>(operation, getter1, getter2);
    }
}

