/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.values;

import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.data.values.NBTGetter;
import net.smileycorp.hordes.common.data.values.ValueGetter;

public class LevelNBTGetter<T extends Comparable<T>>
extends NBTGetter<T> {
    private LevelNBTGetter(ValueGetter<String> value, DataType<T> type) {
        super(value, type);
    }

    @Override
    protected CompoundTag getNBT(Level level, LivingEntity entity, ServerPlayer player, Random rand) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        CompoundTag nbt = server.m_129910_().m_6626_((RegistryAccess)server.m_206579_(), new CompoundTag());
        return nbt;
    }

    public static <T extends Comparable<T>> ValueGetter deserialize(JsonObject object, DataType<T> type) {
        try {
            if (object.has("value")) {
                return new LevelNBTGetter<T>(ValueGetter.readValue(DataType.STRING, object.get("value")), type);
            }
        }
        catch (Exception e) {
            HordesLogger.logError("invalid value for hordes:level_nbt", e);
        }
        return null;
    }
}

