/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.data.values;

import com.google.gson.JsonElement;
import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.data.DataRegistry;
import net.smileycorp.hordes.common.data.values.RandomValue;
import net.smileycorp.hordes.common.event.HordePlayerEvent;

public interface ValueGetter<T extends Comparable<T>> {
    public T get(Level var1, LivingEntity var2, ServerPlayer var3, Random var4);

    default public T get(HordePlayerEvent event) {
        return this.get(event.getEntityWorld(), event.getEntity(), event.getPlayer(), event.getRandom());
    }

    public static <T extends Comparable<T>> ValueGetter<T> readValue(DataType<T> type, JsonElement value) {
        if (value.isJsonObject()) {
            return DataRegistry.readValue(type, value.getAsJsonObject());
        }
        if (value.isJsonArray()) {
            return new RandomValue<T>(type, value.getAsJsonArray());
        }
        Comparable v = type.readFromJson(value);
        return (l, e, p, r) -> v;
    }
}

