/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.config;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import net.minecraft.network.chat.TextColor;
import net.minecraftforge.common.ForgeConfigSpec;
import net.smileycorp.hordes.common.HordesLogger;

public class ClientConfigHandler {
    public static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec config;
    private static TextColor hordeMessageColour;
    private static Color zombiePlayerColour;
    private static Color drownedPlayerColour;
    private static Color huskPlayerColour;
    private static Color hordeEventSkyColour;
    private static Color hordeEventMoonColour;
    public static ForgeConfigSpec.ConfigValue<Integer> eventNotifyMode;
    public static ForgeConfigSpec.ConfigValue<Integer> eventNotifyDuration;
    public static ForgeConfigSpec.ConfigValue<Boolean> hordeSpawnSound;
    private static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configHordeMessageColour;
    public static ForgeConfigSpec.ConfigValue<Boolean> hordeEventTintsSky;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configHordeEventSkyColour;
    public static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configHordeEventMoonColour;
    public static ForgeConfigSpec.ConfigValue<Boolean> playerInfectionVisuals;
    public static ForgeConfigSpec.ConfigValue<Boolean> playerInfectSound;
    public static ForgeConfigSpec.ConfigValue<Boolean> infectionProtectSound;
    public static ForgeConfigSpec.ConfigValue<Boolean> cureTooltip;
    public static ForgeConfigSpec.ConfigValue<Boolean> immunityTooltip;
    public static ForgeConfigSpec.ConfigValue<Boolean> wearableProtectionTooltip;
    private static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configZombiePlayerColour;
    private static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configDrownedPlayerColour;
    private static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configHuskPlayerColour;

    public static TextColor getHordeMessageColour() {
        if (hordeMessageColour == null) {
            List rgb = (List)configHordeMessageColour.get();
            hordeMessageColour = rgb.size() >= 3 ? TextColor.m_131266_((int)(((Integer)rgb.get(0) << 16) + ((Integer)rgb.get(1) << 8) + (Integer)rgb.get(2))) : TextColor.m_131266_((int)0);
        }
        return hordeMessageColour;
    }

    public static Color getHordeSkyColour() {
        if (hordeEventSkyColour == null) {
            List rgb = (List)configHordeEventSkyColour.get();
            hordeEventSkyColour = rgb.size() >= 3 ? new Color((Integer)rgb.get(0), (Integer)rgb.get(1), (Integer)rgb.get(2)) : new Color(102, 0, 0);
        }
        return hordeEventSkyColour;
    }

    public static Color getHordeMoonColour() {
        if (hordeEventMoonColour == null) {
            List rgb = (List)configHordeEventMoonColour.get();
            hordeEventMoonColour = rgb.size() >= 3 ? new Color((Integer)rgb.get(0), (Integer)rgb.get(1), (Integer)rgb.get(2)) : new Color(193, 57, 15);
        }
        return hordeEventMoonColour;
    }

    public static Color getZombiePlayerColour() {
        if (zombiePlayerColour == null) {
            List rgb = (List)configZombiePlayerColour.get();
            zombiePlayerColour = rgb.size() >= 3 ? new Color((Integer)rgb.get(0), (Integer)rgb.get(1), (Integer)rgb.get(2)) : new Color(121, 156, 101);
        }
        return zombiePlayerColour;
    }

    public static Color getDrownedPlayerColour() {
        if (drownedPlayerColour == null) {
            List rgb = (List)configDrownedPlayerColour.get();
            drownedPlayerColour = rgb.size() >= 3 ? new Color((Integer)rgb.get(0), (Integer)rgb.get(1), (Integer)rgb.get(2)) : new Color(144, 255, 255);
        }
        return drownedPlayerColour;
    }

    public static Color getHuskPlayerColour() {
        if (huskPlayerColour == null) {
            List rgb = (List)configHuskPlayerColour.get();
            huskPlayerColour = rgb.size() >= 3 ? new Color((Integer)rgb.get(0), (Integer)rgb.get(1), (Integer)rgb.get(2)) : new Color(193, 168, 5);
        }
        return huskPlayerColour;
    }

    static {
        hordeMessageColour = null;
        zombiePlayerColour = null;
        drownedPlayerColour = null;
        huskPlayerColour = null;
        hordeEventSkyColour = null;
        hordeEventMoonColour = null;
        HordesLogger.logInfo("Trying to load client config");
        builder.push("Horde Event");
        eventNotifyMode = builder.comment("How do players get notified of a horde event. 0: Off, 1: Chat, 2:Action Bar, 3:Title").define("eventNotifyMode", (Object)2);
        eventNotifyDuration = builder.comment("How long in ticks does the horde notification appear? (Only applies to modes 2 and 3)").define("eventNotifyDuration", (Object)60);
        hordeSpawnSound = builder.comment("Play a sound when a horde wave spawns.").define("hordeSpawnSound", true);
        configHordeMessageColour = builder.comment("Colour of horde notification messages in the rgb format.").defineList("hordeMessageColour", (List)Lists.newArrayList((Object[])new Integer[]{135, 0, 0}), x -> (Integer)x >= 0 && (Integer)x < 256);
        hordeEventTintsSky = builder.comment("Whether the sky and moon should be tinted on a horde night").define("hordeEventTintsSky", true);
        configHordeEventSkyColour = builder.comment("Colour of horde notification messages in the rgb format.").defineList("hordeEventSkyColour", (List)Lists.newArrayList((Object[])new Integer[]{102, 0, 0}), x -> (Integer)x >= 0 && (Integer)x < 256);
        configHordeEventMoonColour = builder.comment("Colour of horde notification messages in the rgb format.").defineList("hordeEventMoonColour", (List)Lists.newArrayList((Object[])new Integer[]{193, 57, 15}), x -> (Integer)x >= 0 && (Integer)x < 256);
        builder.pop();
        builder.push("Infection");
        playerInfectionVisuals = builder.comment("Tint the player's screen and display other visual effects if they are infected.").define("playerInfectionVisuals", true);
        playerInfectSound = builder.comment("Play a sound when the player becomes infected?").define("playerInfectSound", true);
        infectionProtectSound = builder.comment("Play a sound when infection gets prevented?").define("infectionProtectSound", false);
        cureTooltip = builder.comment("Show a tooltip on items that can cure infection?").define("cureTooltip", true);
        immunityTooltip = builder.comment("Show a tooltip on items that give infection immunity?").define("immunityTooltip", true);
        wearableProtectionTooltip = builder.comment("Show a tooltip on wearable items that grant some protection against infection?").define("wearableProtectionTooltip", true);
        configZombiePlayerColour = builder.comment("Colour tint for zombie players.").defineList("zombiePlayerColour", (List)Lists.newArrayList((Object[])new Integer[]{121, 156, 101}), x -> (Integer)x >= 0 && (Integer)x < 256);
        configDrownedPlayerColour = builder.comment("Colour tint for drowned players.").defineList("drownedPlayerColour", (List)Lists.newArrayList((Object[])new Integer[]{144, 255, 255}), x -> (Integer)x >= 0 && (Integer)x < 256);
        configHuskPlayerColour = builder.comment("Colour tint for husk players.").defineList("huskPlayerColour", (List)Lists.newArrayList((Object[])new Integer[]{193, 168, 5}), x -> (Integer)x >= 0 && (Integer)x < 256);
        builder.pop();
        config = builder.build();
    }
}

