/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.hordeevent.HordeSpawnType;

public class CustomSpawnType
implements HordeSpawnType {
    private final List<Either<TagKey<Block>, Block>> blocks = Lists.newArrayList();

    public CustomSpawnType(List<String> strings) {
        for (String str : strings) {
            try {
                this.blocks.add((Either<TagKey<Block>, Block>)(str.contains("#") ? Either.left((Object)TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation(str.replace("#", "")))) : Either.right((Object)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(str))))));
            }
            catch (Exception e) {
                HordesLogger.logError("Failed parsing block " + str, e);
            }
        }
    }

    @Override
    public boolean canSpawn(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos.m_7495_());
        for (Either<TagKey<Block>, Block> either : this.blocks) {
            if (!((Boolean)either.map(arg_0 -> ((BlockState)state).m_204336_(arg_0), arg_0 -> ((BlockState)state).m_60713_(arg_0))).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public ListTag toNbt() {
        ListTag tag = new ListTag();
        for (Either<TagKey<Block>, Block> either : this.blocks) {
            tag.add((Object)StringTag.m_129297_((String)((String)either.map(t -> "#" + t.f_203868_(), b -> ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b).toString()))));
        }
        return tag;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getClass().getSimpleName() + "[");
        for (Either<TagKey<Block>, Block> either : this.blocks) {
            builder.append((String)either.map(t -> "#" + t.f_203868_(), b -> ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)b).toString()) + ", ");
        }
        return builder.append("]").toString();
    }
}

