/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.material.FluidState;
import net.smileycorp.atlas.api.util.Func;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.hordeevent.CustomSpawnType;
import net.smileycorp.hordes.hordeevent.HordeSpawnType;

public class HordeSpawnTypes {
    private static final Map<String, HordeSpawnType> SPAWN_TYPES = Maps.newHashMap();
    public static final HordeSpawnType AVOID_FLUIDS = HordeSpawnTypes.register("avoid_fluids", (level, pos) -> level.m_8055_(pos.m_7495_()).m_60819_().m_76178_());
    public static final HordeSpawnType PREFER_WATER = HordeSpawnTypes.register("prefer_water", (level, pos) -> level.m_8055_(pos.m_7495_()).m_60819_().m_205070_(FluidTags.f_13131_));
    public static final HordeSpawnType PREFER_LAVA = HordeSpawnTypes.register("prefer_lava", (level, pos) -> level.m_8055_(pos.m_7495_()).m_60819_().m_205070_(FluidTags.f_13132_));
    public static final HordeSpawnType IGNORE_WATER = HordeSpawnTypes.register("ignore_water", (level, pos) -> {
        FluidState state = level.m_8055_(pos.m_7495_()).m_60819_();
        return state.m_76178_() || state.m_205070_(FluidTags.f_13131_);
    });
    public static final HordeSpawnType IGNORE_FLUIDS = HordeSpawnTypes.register("ignore_fluids", (xva$0, xva$1) -> Func.True((Object[])new Object[]{xva$0, xva$1}));

    public static HordeSpawnType register(String name, HordeSpawnType spawnType) {
        SPAWN_TYPES.put(name, spawnType);
        return spawnType;
    }

    public static String toString(HordeSpawnType spawnType) {
        if (spawnType instanceof CustomSpawnType) {
            return spawnType.toString();
        }
        for (Map.Entry<String, HordeSpawnType> entry : SPAWN_TYPES.entrySet()) {
            if (!entry.getValue().equals(spawnType)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Tag toNbt(HordeSpawnType spawnType) {
        if (spawnType instanceof CustomSpawnType) {
            return ((CustomSpawnType)spawnType).toNbt();
        }
        for (Map.Entry<String, HordeSpawnType> entry : SPAWN_TYPES.entrySet()) {
            if (!entry.getValue().equals(spawnType)) continue;
            return StringTag.m_129297_((String)entry.getKey());
        }
        return null;
    }

    public static HordeSpawnType fromNBT(Tag tag) {
        if (tag instanceof StringTag) {
            HordeSpawnType type = SPAWN_TYPES.get(tag.m_7916_());
            if (type != null) {
                return type;
            }
        } else if (tag instanceof ListTag) {
            try {
                List<String> strings = ((ListTag)tag).stream().map(Tag::m_7916_).collect(Collectors.toList());
                return new CustomSpawnType(strings);
            }
            catch (Exception e) {
                HordesLogger.logError("Failed reading nbt " + tag, e);
            }
        }
        return AVOID_FLUIDS;
    }

    public static HordeSpawnType fromJson(JsonElement tag) {
        if (tag instanceof JsonPrimitive) {
            HordeSpawnType type = SPAWN_TYPES.get(tag.getAsString());
            if (type != null) {
                return type;
            }
        } else if (tag instanceof JsonArray) {
            try {
                ArrayList strings = Lists.newArrayList();
                ((JsonArray)tag).forEach(e -> strings.add(e.getAsString()));
                return new CustomSpawnType(strings);
            }
            catch (Exception e2) {
                HordesLogger.logError("Failed reading nbt " + tag, e2);
            }
        }
        return AVOID_FLUIDS;
    }
}

