/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.capability;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.config.HordeEventConfig;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;

public class HordeSavedData
extends SavedData {
    public static final String DATA = "hordes_HordeEvent";
    private final Random rand = new Random();
    private int next_day = 0;
    protected Level level = null;
    private Map<UUID, HordeEvent> events = Maps.newHashMap();

    public void load(CompoundTag nbt) {
        int next;
        if (nbt.m_128441_("next_day") && (next = nbt.m_128451_("next_day")) > this.next_day) {
            this.next_day = next;
        }
        if (nbt.m_128441_("events")) {
            CompoundTag events = nbt.m_128469_("events");
            for (String uuid : events.m_128431_()) {
                if (!DataUtils.isValidUUID((String)uuid)) {
                    return;
                }
                HordeEvent horde = new HordeEvent(this);
                horde.readFromNBT(events.m_128469_(uuid));
                this.events.put(UUID.fromString(uuid), horde);
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128405_("next_day", this.next_day);
        CompoundTag events = new CompoundTag();
        for (Map.Entry<UUID, HordeEvent> entry : this.events.entrySet()) {
            UUID uuid = entry.getKey();
            CompoundTag tag = new CompoundTag();
            events.m_128365_(uuid.toString(), (Tag)entry.getValue().writeToNBT(tag, uuid));
        }
        nbt.m_128365_("events", (Tag)events);
        return nbt;
    }

    public int getNextDay() {
        return this.next_day;
    }

    public void setNextDay(int next_day) {
        this.next_day = next_day;
    }

    public void save() {
        this.m_77762_();
        if (this.level instanceof ServerLevel) {
            ((ServerLevel)this.level).m_7726_().m_8483_().m_164855_(DATA, (SavedData)this);
        }
    }

    public HordeEvent getEvent(ServerPlayer player) {
        return player == null ? null : this.getEvent(player.m_142081_());
    }

    public HordeEvent getEvent(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        if (!this.events.containsKey(uuid)) {
            this.events.put(uuid, new HordeEvent(this));
        }
        return this.events.get(uuid);
    }

    public String getName(UUID uuid) {
        ServerPlayer player = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(uuid);
        if (player != null) {
            return player.m_7755_().getString();
        }
        Optional profile = ServerLifecycleHooks.getCurrentServer().m_129927_().m_11002_(uuid);
        if (profile.isPresent() && ((GameProfile)profile.get()).getName() != null) {
            return ((GameProfile)profile.get()).getName();
        }
        return uuid.toString();
    }

    public Random getRandom() {
        return this.rand;
    }

    public String toString() {
        return super.toString() + "[current_day: " + (int)Math.floor((float)this.level.m_46468_() / (float)((Integer)HordeEventConfig.dayLength.get()).intValue()) + ", current_time: " + this.level.m_46468_() % (long)((Integer)HordeEventConfig.dayLength.get()).intValue() + ", next_day=" + this.next_day + "]";
    }

    public List<String> getDebugText() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.toString());
        out.add("Existing events: {");
        for (Map.Entry<UUID, HordeEvent> entry : this.events.entrySet()) {
            out.add("\t" + entry.getValue().toString(this.getName(entry.getKey())));
            out.addAll(entry.getValue().getEntityStrings());
        }
        out.add("}");
        return out;
    }

    public static HordeSavedData getData(ServerLevel level) {
        HordeSavedData data = (HordeSavedData)level.m_7726_().m_8483_().m_164861_(nbt -> HordeSavedData.getDataFromNBT(level, nbt), () -> HordeSavedData.getCleanData(level), DATA);
        if (data == null) {
            data = HordeSavedData.getCleanData(level);
        }
        level.m_7726_().m_8483_().m_164855_(DATA, (SavedData)data);
        return data;
    }

    private static HordeSavedData getDataFromNBT(ServerLevel level, CompoundTag nbt) {
        HordeSavedData data = HordeSavedData.getCleanData(level);
        data.load(nbt);
        return data;
    }

    public static HordeSavedData getCleanData(ServerLevel level) {
        HordeSavedData data = new HordeSavedData();
        data.level = level;
        int day = Math.round(level.m_46468_() / (long)((Integer)HordeEventConfig.dayLength.get()).intValue());
        double multiplier = Math.ceil(day / (Integer)HordeEventConfig.hordeSpawnDays.get());
        if (!((Boolean)HordeEventConfig.spawnFirstDay.get()).booleanValue() || day != 0) {
            multiplier += 1.0;
        }
        int nextDay = (int)Math.floor(multiplier * (double)((Integer)HordeEventConfig.hordeSpawnDays.get()).intValue() + (double)level.f_46441_.nextInt((Integer)HordeEventConfig.hordeSpawnVariation.get() + 1));
        data.setNextDay(nextDay);
        return data;
    }
}

