/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.capability;

import java.util.UUID;
import net.minecraft.core.Direction;
import net.minecraft.nbt.StringTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.capability.HordesCapabilities;

public interface HordeSpawn {
    public boolean isHordeSpawned();

    public void setPlayerUUID(String var1);

    public String getPlayerUUID();

    public boolean isSynced();

    public void setSynced();

    public StringTag writeNBT();

    public void readNBT(StringTag var1);

    public static ServerPlayer getHordePlayer(Entity entity) {
        if (entity.f_19853_.f_46443_ | !(entity instanceof Mob)) {
            return null;
        }
        LazyOptional optional = entity.getCapability(HordesCapabilities.HORDESPAWN);
        if (!optional.isPresent()) {
            return null;
        }
        HordeSpawn cap = (HordeSpawn)optional.orElseGet(null);
        if (!cap.isHordeSpawned()) {
            return null;
        }
        String uuid = cap.getPlayerUUID();
        if (!DataUtils.isValidUUID((String)uuid)) {
            return null;
        }
        return ServerLifecycleHooks.getCurrentServer().m_6846_().m_11259_(UUID.fromString(uuid));
    }

    public static class Provider
    implements ICapabilitySerializable<StringTag> {
        protected HordeSpawn impl = new Impl();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
            return cap == HordesCapabilities.HORDESPAWN ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public StringTag serializeNBT() {
            return this.impl.writeNBT();
        }

        public void deserializeNBT(StringTag nbt) {
            this.impl.readNBT(nbt);
        }
    }

    public static class Impl
    implements HordeSpawn {
        private String uuid = "";
        private boolean isSynced;

        @Override
        public boolean isHordeSpawned() {
            return !this.uuid.isEmpty();
        }

        @Override
        public void setPlayerUUID(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public String getPlayerUUID() {
            return this.uuid;
        }

        @Override
        public boolean isSynced() {
            return this.isSynced;
        }

        @Override
        public void setSynced() {
            this.isSynced = true;
        }

        @Override
        public StringTag writeNBT() {
            return StringTag.m_129297_((String)this.uuid);
        }

        @Override
        public void readNBT(StringTag tag) {
            this.uuid = tag.m_7916_();
        }
    }
}

