/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;

public class CommandResetHordeEvent {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reset").requires(commandSource -> commandSource.m_6761_(1))).executes(ctx -> CommandResetHordeEvent.execute((CommandContext<CommandSourceStack>)ctx))).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> CommandResetHordeEvent.execute((CommandContext<CommandSourceStack>)ctx, EntityArgument.m_91477_((CommandContext)ctx, (String)"player")))));
    }

    public static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        if (source.m_81373_() instanceof Player) {
            return CommandResetHordeEvent.execute(ctx, Lists.newArrayList((Object[])new ServerPlayer[]{source.m_81375_()}));
        }
        return 0;
    }

    public static int execute(CommandContext<CommandSourceStack> ctx, Collection<ServerPlayer> players) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        for (ServerPlayer player : players) {
            HordeEvent horde = HordeSavedData.getData(source.m_81372_()).getEvent(player);
            if (horde == null) continue;
            horde.reset(player);
            source.m_81373_().m_6352_((Component)new TranslatableComponent("commands.hordes.HordeReset.success", new Object[]{player.m_7755_()}), null);
            return 1;
        }
        return 0;
    }
}

