/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.smileycorp.hordes.common.mixinutils.ChatName;
import net.smileycorp.hordes.hordeevent.capability.HordeEvent;
import net.smileycorp.hordes.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.hordeevent.capability.HordeSpawn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity
implements ChatName {
    @Shadow
    public Level f_19853_;
    private String chatName;

    @Inject(at={@At(value="HEAD")}, method={"getTypeName"}, cancellable=true)
    protected void getTypeName(CallbackInfoReturnable<Component> callback) {
        if (this.hasChatName()) {
            callback.setReturnValue((Object)new TranslatableComponent(this.getChatName()));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"remove"}, cancellable=true)
    protected void remove(Entity.RemovalReason reason, CallbackInfo callback) {
        ServerPlayer player = HordeSpawn.getHordePlayer((Entity)this);
        if (player == null) {
            return;
        }
        HordeEvent horde = HordeSavedData.getData((ServerLevel)player.f_19853_).getEvent(player);
        if (horde != null) {
            horde.removeEntity((Mob)this);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"load"})
    public void load(CompoundTag nbt, CallbackInfo callback) {
        if (!(this.f_19853_ instanceof ServerLevel) | !(this instanceof ServerPlayer)) {
            return;
        }
        if (!nbt.m_128425_("ForgeCaps", 10)) {
            return;
        }
        CompoundTag caps = nbt.m_128469_("ForgeCaps");
        if (!caps.m_128425_("hordes:hordeevent", 10)) {
            return;
        }
        HordeSavedData data = HordeSavedData.getData((ServerLevel)this.f_19853_);
        HordeEvent event = data.getEvent((ServerPlayer)this);
        event.readFromNBT(caps.m_128469_("hordes:hordeevent"));
    }

    @Override
    public boolean hasChatName() {
        return this.chatName != null;
    }

    @Override
    public String getChatName() {
        return this.chatName;
    }

    @Override
    public void setChatName(String name) {
        this.chatName = name;
    }
}

