/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkDirection;
import net.smileycorp.hordes.config.InfectionConfig;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.InfectedEffect;
import net.smileycorp.hordes.infection.network.InfectMessage;
import net.smileycorp.hordes.infection.network.InfectionPacketHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MobEffectInstance.class})
public class MixinMobEffectInstance {
    @Shadow
    private MobEffect f_19502_;
    @Shadow
    private int f_19503_;
    @Shadow
    private int f_19504_;

    @Inject(at={@At(value="HEAD")}, method={"tick(Lnet/minecraft/world/entity/LivingEntity;Ljava/lang/Runnable;)Z"}, cancellable=true)
    public void tick(LivingEntity entity, Runnable onUpdate, CallbackInfoReturnable<Boolean> callback) {
        if (this.f_19503_ <= 1 && this.f_19502_ == HordesInfection.INFECTED.get() && ((Boolean)InfectionConfig.enableMobInfection.get()).booleanValue()) {
            if (this.f_19504_ < 3) {
                ++this.f_19504_;
                this.f_19503_ = InfectedEffect.getInfectionTime(entity);
                if (entity instanceof ServerPlayer) {
                    InfectionPacketHandler.sendTo(new InfectMessage(false), ((ServerPlayer)entity).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
                callback.setReturnValue((Object)true);
            } else {
                entity.m_6469_(HordesInfection.INFECTION_DAMAGE, Float.MAX_VALUE);
                callback.setReturnValue((Object)false);
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"load(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/world/effect/MobEffectInstance;"}, cancellable=true)
    private static void load(CompoundTag nbt, CallbackInfoReturnable<MobEffectInstance> callback) {
        MobEffectInstance effect = (MobEffectInstance)callback.getReturnValue();
        if (effect.m_19544_() == HordesInfection.INFECTED.get() && effect.f_19503_ > (Integer)InfectionConfig.ticksForEffectStage.get()) {
            int d = effect.f_19503_ + (Integer)InfectionConfig.ticksForEffectStage.get() - 10000;
            effect.f_19503_ = d > 0 ? d : (Integer)InfectionConfig.ticksForEffectStage.get();
        }
    }
}

