/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.block.FurnitureHorizontalBlock;
import com.mrcrayfish.furniture.refurbished.data.tag.BlockTagSupplier;
import com.mrcrayfish.furniture.refurbished.entity.Seat;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import com.mrcrayfish.furniture.refurbished.util.VoxelShapeHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SofaBlock
extends FurnitureHorizontalBlock
implements BlockTagSupplier {
    private static final MapCodec<SofaBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)DyeColor.CODEC.fieldOf("color").forGetter(block -> block.color), (App)SofaBlock.propertiesCodec()).apply((Applicative)builder, SofaBlock::new));
    public static final EnumProperty<Shape> SHAPE = EnumProperty.create((String)"shape", Shape.class);
    private final DyeColor color;

    public SofaBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.color = color;
    }

    public DyeColor getDyeColor() {
        return this.color;
    }

    protected MapCodec<SofaBlock> codec() {
        return CODEC;
    }

    @Override
    protected Map<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape baseShape = Block.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape frontLeftLegShape = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0);
        VoxelShape frontRightLegShape = Block.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0);
        VoxelShape backLeftLegShape = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0);
        VoxelShape backRightLegShape = Block.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0);
        VoxelShape leftArmShape = Block.box((double)0.0, (double)6.0, (double)-2.0, (double)16.0, (double)14.0, (double)2.0);
        VoxelShape rightArmShape = Block.box((double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)14.0, (double)18.0);
        VoxelShape backRestShape = Block.box((double)12.0, (double)10.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
        return ImmutableMap.copyOf(states.stream().collect(Collectors.toMap(state -> state, state -> {
            ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>();
            shapes.add(baseShape);
            shapes.add(backRestShape);
            switch (((Shape)((Object)((Object)state.getValue(SHAPE)))).ordinal()) {
                case 0: {
                    shapes.add(frontLeftLegShape);
                    shapes.add(frontRightLegShape);
                    shapes.add(backLeftLegShape);
                    shapes.add(backRightLegShape);
                    shapes.add(leftArmShape);
                    shapes.add(rightArmShape);
                    break;
                }
                case 1: {
                    shapes.add(frontLeftLegShape);
                    shapes.add(backLeftLegShape);
                    shapes.add(leftArmShape);
                    break;
                }
                case 2: {
                    shapes.add(frontRightLegShape);
                    shapes.add(backRightLegShape);
                    shapes.add(rightArmShape);
                    break;
                }
                case 4: {
                    shapes.add(backLeftLegShape);
                    shapes.add(VoxelShapeHelper.rotateHorizontally(backRestShape, Direction.NORTH));
                    break;
                }
                case 5: {
                    shapes.add(backRightLegShape);
                    shapes.add(VoxelShapeHelper.rotateHorizontally(backRestShape, Direction.SOUTH));
                }
            }
            return VoxelShapeHelper.rotateHorizontally(VoxelShapeHelper.combine(shapes), (Direction)state.getValue((Property)DIRECTION));
        })));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state != null) {
            return (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, (LevelReader)context.getLevel(), context.getClickedPos())));
        }
        return null;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (Seat.sit(player, pos, Utils.pixels(10.0), ((Direction)state.getValue((Property)DIRECTION)).getOpposite())) {
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected BlockState updateShape(BlockState state, LevelReader reader, ScheduledTickAccess access, BlockPos pos, Direction direction, BlockPos pos1, BlockState state1, RandomSource rand) {
        return (BlockState)state.setValue(SHAPE, (Comparable)((Object)this.getShape(state, reader, pos)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{SHAPE});
    }

    public Shape getShape(BlockState state, LevelReader reader, BlockPos pos) {
        Direction facing = (Direction)state.getValue((Property)DIRECTION);
        Direction front = this.getSofaDirection(reader, pos, facing.getOpposite());
        if (front != null) {
            if (front == facing.getClockWise()) {
                return Shape.CORNER_RIGHT;
            }
            if (front == facing.getCounterClockWise()) {
                return Shape.CORNER_LEFT;
            }
        }
        boolean left = this.isConnectable(reader, pos, facing, facing.getCounterClockWise());
        boolean right = this.isConnectable(reader, pos, facing, facing.getClockWise());
        if (left && right) {
            return Shape.MIDDLE;
        }
        if (left) {
            return Shape.RIGHT;
        }
        if (right) {
            return Shape.LEFT;
        }
        return Shape.DEFAULT;
    }

    private Direction getSofaDirection(LevelReader reader, BlockPos pos, Direction side) {
        BlockState relativeState = reader.getBlockState(pos.relative(side));
        return relativeState.getBlock() instanceof SofaBlock ? (Direction)relativeState.getValue((Property)DIRECTION) : null;
    }

    private boolean isConnectable(LevelReader reader, BlockPos pos, Direction facing, Direction offset) {
        BlockPos relativePos = pos.relative(offset);
        BlockState relativeState = reader.getBlockState(pos.relative(offset));
        if (relativeState.getBlock() instanceof SofaBlock) {
            Direction other = (Direction)relativeState.getValue((Property)DIRECTION);
            return other == facing || other == offset;
        }
        return relativeState.isFaceSturdy((BlockGetter)reader, relativePos, offset.getOpposite());
    }

    @Override
    public List<TagKey<Block>> getTags() {
        return List.of(BlockTags.MINEABLE_WITH_AXE);
    }

    public static enum Shape implements StringRepresentable
    {
        DEFAULT("default"),
        LEFT("left"),
        RIGHT("right"),
        MIDDLE("middle"),
        CORNER_LEFT("corner_left"),
        CORNER_RIGHT("corner_right");

        private final String name;

        private Shape(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

