/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.block.BathBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.IWaterTap;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.FluidContainer;
import com.mrcrayfish.furniture.refurbished.blockentity.fluid.IFluidContainerBlock;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModParticleTypes;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BathBlockEntity
extends BlockEntity
implements IFluidContainerBlock,
IWaterTap {
    protected final FluidContainer tank;
    private int animationTime;

    public BathBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.BATH.get(), pos, state);
    }

    public BathBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tank = this.createFluidContainer(state);
    }

    public boolean isHead() {
        return this.tank != null;
    }

    @Override
    public FluidContainer getFluidContainer() {
        return this.tank != null ? this.tank : this.getFluidContainerFromHead();
    }

    @Nullable
    private FluidContainer getFluidContainerFromHead() {
        BlockState state = this.getBlockState();
        if (state.hasProperty((Property)BathBlock.DIRECTION)) {
            Direction direction = (Direction)state.getValue((Property)BathBlock.DIRECTION);
            Level level = Objects.requireNonNull(this.level);
            BlockEntity blockEntity = level.getBlockEntity(this.worldPosition.relative(direction));
            if (blockEntity instanceof BathBlockEntity) {
                BathBlockEntity bath = (BathBlockEntity)blockEntity;
                return bath.getFluidContainer();
            }
        }
        return null;
    }

    @Nullable
    private FluidContainer createFluidContainer(BlockState state) {
        if (state.hasProperty(BathBlock.TYPE) && state.getValue(BathBlock.TYPE) == BathBlock.Type.HEAD) {
            return FluidContainer.create((Long)Config.SERVER.bath.fluidCapacity.get(), container -> {
                this.setChanged();
                container.sync(this);
            });
        }
        return null;
    }

    public InteractionResult interact(Player player, InteractionHand hand, BlockHitResult result) {
        FluidContainer tank = this.getFluidContainer();
        if (tank == null) {
            return InteractionResult.CONSUME;
        }
        if (this.interactWithBottle(player, hand, this.worldPosition).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        if (this.performPlatformInteraction(player, hand, this.worldPosition, result.getDirection()).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        if (((Boolean)Config.SERVER.bath.dispenseWater.get()).booleanValue() && result.getDirection() != Direction.DOWN) {
            if (this.tryAndFillWithFluid(this.level, this.worldPosition, (Fluid)Fluids.WATER, Vec3.atCenterOf((Vec3i)this.worldPosition)).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryAndCreateObsidian(this.level, this.worldPosition, (Fluid)Fluids.WATER, Vec3.atBottomCenterOf((Vec3i)this.worldPosition).add(0.0, 1.0, 0.0)).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    @Override
    public void playWaterAnimation() {
        if (this.isHead()) {
            this.animationTime = 4;
        } else {
            BlockState state = this.getBlockState();
            if (state.hasProperty((Property)BathBlock.DIRECTION)) {
                BathBlockEntity bath;
                BlockEntity blockEntity;
                BlockPos headPos = this.worldPosition.relative((Direction)state.getValue((Property)BathBlock.DIRECTION));
                if (this.level != null && (blockEntity = this.level.getBlockEntity(headPos)) instanceof BathBlockEntity && (bath = (BathBlockEntity)blockEntity).isHead()) {
                    bath.playWaterAnimation();
                }
            }
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, BathBlockEntity bath) {
        if (bath.animationTime > 0) {
            Vec3 tap = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, Utils.pixels(18.0), 0.0);
            tap = tap.relative((Direction)state.getValue((Property)BathBlock.DIRECTION), Utils.pixels(2.0));
            for (int i = 0; i < 5; ++i) {
                double x = tap.x + Utils.pixels(0.5) * level.random.nextGaussian();
                double z = tap.z + Utils.pixels(0.5) * level.random.nextGaussian();
                level.addParticle((ParticleOptions)ModParticleTypes.TAP_WATER.get(), x, tap.y, z, 0.0, 0.0, 0.0);
            }
            --bath.animationTime;
        }
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        if (this.tank != null) {
            this.tank.load(input.childOrEmpty("FluidTank"));
        }
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (this.tank != null) {
            this.tank.save(output.child("FluidTank"));
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }
}

