/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.client.gui.ClientWorkbenchRecipeIngredientTooltip;
import com.mrcrayfish.furniture.refurbished.client.gui.ClientWorkbenchRecipeTooltip;
import com.mrcrayfish.furniture.refurbished.client.gui.screen.ElectricityContainerScreen;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.core.ModTags;
import com.mrcrayfish.furniture.refurbished.crafting.StackedIngredient;
import com.mrcrayfish.furniture.refurbished.crafting.WorkbenchContructingRecipe;
import com.mrcrayfish.furniture.refurbished.inventory.WorkbenchMenu;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageWorkbench;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class WorkbenchScreen
extends ElectricityContainerScreen<WorkbenchMenu> {
    public static final ResourceLocation WORKBENCH_TEXTURE = Utils.resource("textures/gui/container/workbench.png");
    public static final WidgetSprites FILTER_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_enabled_highlighted"), ResourceLocation.withDefaultNamespace((String)"recipe_book/filter_disabled_highlighted"));
    public static final WidgetSprites SEARCH_NEIGHBOURS_SPRITES = new WidgetSprites(Utils.resource("search_neighbours_selected"), Utils.resource("search_neighbours_unselected"), Utils.resource("search_neighbours_selected_focused"), Utils.resource("search_neighbours_unselected_focused"));
    private static final int BUTTON_SIZE = 20;
    private static final int RECIPES_PER_ROW = 6;
    private static final int WINDOW_WIDTH = 120;
    private static final int WINDOW_HEIGHT = 88;
    private static final int SCROLL_SPEED = 10;
    private static final int SCROLLBAR_HEIGHT = 15;
    private static final int SCROLLBAR_AREA = 106;
    private static final Category CATEGORY_ALL = new Category(new TagKey[0]);
    private static final Category CATEGORY_GENERAL = new Category(ModTags.Items.GENERAL, ModTags.Items.BEDROOM);
    private static final Category CATEGORY_KITCHEN = new Category(ModTags.Items.KITCHEN);
    private static final Category CATEGORY_OUTDOORS = new Category(ModTags.Items.OUTDOORS);
    private static final Category CATEGORY_BATHROOM = new Category(ModTags.Items.BATHROOM);
    private static final Category CATEGORY_ELECTRONICS = new Category(ModTags.Items.ELECTRONICS);
    private static final List<Category> CATEGORIES = List.of(CATEGORY_ALL, CATEGORY_GENERAL, CATEGORY_KITCHEN, CATEGORY_OUTDOORS, CATEGORY_BATHROOM, CATEGORY_ELECTRONICS);
    private static boolean craftableOnly;
    protected final Map<ResourceLocation, Integer> recipeToIndex;
    protected final List<RecipeHolder<WorkbenchContructingRecipe>> displayRecipes = new ArrayList<RecipeHolder<WorkbenchContructingRecipe>>();
    protected StateSwitchingButton craftableOnlyButton;
    protected StateSwitchingButton searchNeighboursButton;
    protected double scroll;
    protected int hoveredIndex = -1;
    protected int clickedY = -1;

    public WorkbenchScreen(WorkbenchMenu menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, title);
        this.imageWidth = 216;
        this.imageHeight = 229;
        this.inventoryLabelX = 28;
        this.inventoryLabelY = this.imageHeight - 94;
        ((WorkbenchMenu)this.menu).setUpdateCallback(this::updateRecipes);
        this.recipeToIndex = (Map)Util.make(() -> {
            HashMap<ResourceLocation, Integer> map = new HashMap<ResourceLocation, Integer>();
            List<RecipeHolder<WorkbenchContructingRecipe>> recipes = menu.getRecipes();
            for (int i = 0; i < recipes.size(); ++i) {
                map.put(recipes.get(i).id().location(), i);
            }
            return ImmutableMap.copyOf(map);
        });
        this.updateRecipes();
        this.scrollToSelected();
    }

    private void updateRecipes() {
        this.displayRecipes.clear();
        Category selectedCategory = CATEGORIES.stream().filter(Category::isEnabled).findFirst().orElse(CATEGORY_ALL);
        for (RecipeHolder<WorkbenchContructingRecipe> holder2 : ((WorkbenchMenu)this.menu).getRecipes()) {
            if (!selectedCategory.in(((WorkbenchContructingRecipe)holder2.value()).getResult()) || craftableOnly && !((WorkbenchMenu)this.menu).canCraft(holder2)) continue;
            this.displayRecipes.add(holder2);
        }
        this.displayRecipes.sort(Comparator.comparing(holder -> ((WorkbenchContructingRecipe)holder.value()).getResultId()));
    }

    @Override
    protected int getBannerTop() {
        return this.topPos + 52;
    }

    protected void init() {
        super.init();
        this.craftableOnlyButton = (StateSwitchingButton)this.addRenderableWidget((GuiEventListener)new CraftableButton(this.leftPos + 184, this.topPos + 44, 26, 16, craftableOnly));
        this.craftableOnlyButton.initTextureValues(FILTER_BUTTON_SPRITES);
        this.searchNeighboursButton = (StateSwitchingButton)this.addRenderableWidget((GuiEventListener)new SearchNeighboursButton(this.leftPos + 184, this.topPos + 62, 26, 16, ((WorkbenchMenu)this.menu).shouldSearchNeighbours()));
        this.searchNeighboursButton.initTextureValues(SEARCH_NEIGHBOURS_SPRITES);
        this.addRenderableWidget((GuiEventListener)new CategoryButton(this.leftPos + 46, this.topPos + 108, 236, 55, CATEGORY_ALL));
        this.addRenderableWidget((GuiEventListener)new CategoryButton(this.leftPos + 66, this.topPos + 108, 236, 69, CATEGORY_GENERAL));
        this.addRenderableWidget((GuiEventListener)new CategoryButton(this.leftPos + 86, this.topPos + 108, 236, 83, CATEGORY_KITCHEN));
        this.addRenderableWidget((GuiEventListener)new CategoryButton(this.leftPos + 106, this.topPos + 108, 236, 97, CATEGORY_OUTDOORS));
        this.addRenderableWidget((GuiEventListener)new CategoryButton(this.leftPos + 126, this.topPos + 108, 236, 111, CATEGORY_BATHROOM));
        this.addRenderableWidget((GuiEventListener)new CategoryButton(this.leftPos + 146, this.topPos + 108, 236, 125, CATEGORY_ELECTRONICS));
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.searchNeighboursButton.setStateTriggered(((WorkbenchMenu)this.menu).shouldSearchNeighbours());
        super.render(graphics, mouseX, mouseY, partialTick);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (((WorkbenchMenu)this.menu).isPowered() && this.hoveredIndex != -1) {
            this.renderRecipeTooltip(graphics, mouseX, mouseY, this.hoveredIndex);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        graphics.blit(RenderPipelines.GUI_TEXTURED, WORKBENCH_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.renderScrollbar(graphics, mouseY);
        this.renderRecipes(graphics, partialTick, mouseX, mouseY);
        this.renderOverlay(graphics);
        super.renderBg(graphics, partialTick, mouseX, mouseY);
        if (this.isHovering(199, 5, 10, 10, mouseX, mouseY)) {
            graphics.setTooltipForNextFrame(ScreenHelper.createMultilineTooltip(List.of(Utils.translation("gui", "how_to", new Object[0]).withStyle(ChatFormatting.GOLD), Utils.translation("gui", "workbench_info", new Object[0]))).toCharSequence(this.minecraft), mouseX, mouseY);
        }
    }

    private void renderScrollbar(GuiGraphics graphics, int mouseY) {
        int textureU = this.getMaxScroll() > 0 ? 216 : 228;
        graphics.blit(RenderPipelines.GUI_TEXTURED, WORKBENCH_TEXTURE, this.leftPos + 169, this.topPos + 18 + this.getScrollbarPosition(mouseY), (float)textureU, 40.0f, 12, 15, 256, 256);
    }

    private void renderRecipes(GuiGraphics graphics, float partialTick, int mouseX, int mouseY) {
        this.hoveredIndex = -1;
        graphics.enableScissor(this.leftPos + 46, this.topPos + 18, this.leftPos + 46 + 120, this.topPos + 18 + 88);
        List<RecipeHolder<WorkbenchContructingRecipe>> recipes = this.displayRecipes;
        double scroll = this.getScrollAmount(mouseY);
        int startIndex = (int)(scroll / 20.0) * 6;
        int endIndex = startIndex + Mth.ceil((double)5.4) * 6;
        boolean mouseInWindow = ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 46, this.topPos + 18, 120, 88);
        for (int i = startIndex; i < endIndex && i < recipes.size(); ++i) {
            RecipeHolder<WorkbenchContructingRecipe> recipe = recipes.get(i);
            int recipeIndex = this.recipeToIndex.get(recipe.id().location());
            boolean canCraft = ((WorkbenchMenu)this.menu).canCraft(recipe);
            boolean selected = recipeIndex == ((WorkbenchMenu)this.menu).getSelectedRecipeIndex();
            int buttonX = this.leftPos + 46 + i % 6 * 20;
            int buttonY = this.topPos + 18 + i / 6 * 20 - (int)scroll;
            int textureU = 216 + (!canCraft ? 20 : 0);
            int textureV = selected ? 20 : 0;
            graphics.blit(RenderPipelines.GUI_TEXTURED, WORKBENCH_TEXTURE, buttonX, buttonY, (float)textureU, (float)textureV, 20, 20, 256, 256);
            graphics.renderFakeItem(((WorkbenchContructingRecipe)recipe.value()).getResult(), buttonX + 2, buttonY + 2);
            if (!mouseInWindow || !ScreenHelper.isMouseWithinBounds(mouseX, mouseY, buttonX, buttonY, 20, 20)) continue;
            this.hoveredIndex = recipeIndex;
        }
        graphics.disableScissor();
    }

    private void renderOverlay(GuiGraphics graphics) {
        if (!((WorkbenchMenu)this.menu).isPowered()) {
            graphics.fill(this.leftPos + 46, this.topPos + 18, this.leftPos + 46 + 120, this.topPos + 18 + 88, -1442840576);
        }
    }

    private void renderRecipeTooltip(GuiGraphics graphics, int mouseX, int mouseY, int recipeIndex) {
        RecipeHolder<WorkbenchContructingRecipe> holder = ((WorkbenchMenu)this.menu).getRecipes().get(recipeIndex);
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(new ClientTextTooltip(((WorkbenchContructingRecipe)holder.value()).getResult().getHoverName().getVisualOrderText()));
        if (!Screen.hasShiftDown()) {
            components.add(new ClientWorkbenchRecipeTooltip((WorkbenchMenu)this.menu, (WorkbenchContructingRecipe)holder.value()));
            components.add(new ClientTextTooltip(Components.GUI_HOLD_SHIFT_DETAILS.getVisualOrderText()));
        } else {
            HashMap counted = new HashMap();
            ((WorkbenchContructingRecipe)holder.value()).getMaterials().forEach(material -> components.add(new ClientWorkbenchRecipeIngredientTooltip((WorkbenchMenu)this.menu, (StackedIngredient)material, counted)));
        }
        graphics.renderTooltip(this.font, components, mouseX, mouseY, DefaultTooltipPositioner.INSTANCE, null);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            if (((WorkbenchMenu)this.menu).isPowered() && this.hoveredIndex != -1 && this.minecraft != null && this.minecraft.gameMode != null) {
                Network.getPlay().sendToServer((Object)new MessageWorkbench.SelectRecipe(this.hoveredIndex));
                this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
            if (ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 169, this.topPos + 18 + this.getScrollbarPosition((int)mouseY), 12, 15)) {
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY != -1) {
            this.scroll = this.getScrollAmount((int)mouseY);
            this.clickedY = -1;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.clickedY == -1 && ScreenHelper.isMouseWithinBounds(mouseX, mouseY, this.leftPos + 46, this.topPos + 18, 135, 88)) {
            this.scroll = Mth.clamp((double)(this.scroll - deltaY * 10.0), (double)0.0, (double)this.getMaxScroll());
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    private void updateScroll() {
        this.scroll = Mth.clamp((double)this.scroll, (double)0.0, (double)this.getMaxScroll());
    }

    private double getScrollAmount(int mouseY) {
        return Mth.clamp((double)(this.scroll + (double)this.getScrollbarDelta(mouseY)), (double)0.0, (double)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return !((WorkbenchMenu)this.menu).isPowered() ? 0 : Math.max(0, (int)(Math.ceil((double)this.displayRecipes.size() / 6.0) * 20.0) - 88);
    }

    private int getScrollbarPosition(int mouseY) {
        return (int)(this.getScrollAmount(mouseY) / (double)this.getMaxScroll() * 91.0);
    }

    private int getScrollbarDelta(int mouseY) {
        double scrollPerUnit = (double)this.getMaxScroll() / 91.0;
        return this.clickedY != -1 ? (int)((double)(mouseY - this.clickedY) * scrollPerUnit) : 0;
    }

    private void scrollToSelected() {
        int selectedIndex = ((WorkbenchMenu)this.menu).getSelectedRecipeIndex();
        if (selectedIndex >= 0 && selectedIndex < this.displayRecipes.size()) {
            int newScroll = selectedIndex / 6 * 20;
            this.scroll = Mth.clamp((int)(newScroll -= 34), (int)0, (int)this.getMaxScroll());
        }
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        if (listener == this.craftableOnlyButton || listener == this.searchNeighboursButton) {
            return;
        }
        super.setFocused(listener);
    }

    public static class Category {
        private final TagKey<Item>[] tags;
        private boolean enabled;

        @SafeVarargs
        private Category(TagKey<Item> ... tags) {
            this.tags = tags;
            this.enabled = tags.length == 0;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean in(ItemStack result) {
            if (this.tags.length == 0) {
                return true;
            }
            for (TagKey<Item> tag : this.tags) {
                if (!result.is(tag)) continue;
                return true;
            }
            return false;
        }
    }

    private class CraftableButton
    extends StateSwitchingButton {
        private static final Component VANILLA_ONLY_CRAFTABLE = Component.translatable((String)"gui.recipebook.toggleRecipes.craftable");
        private static final Component VANILLA_ALL_RECIPES = Component.translatable((String)"gui.recipebook.toggleRecipes.all");

        public CraftableButton(int x, int y, int width, int height, boolean state) {
            super(x, y, width, height, state);
            this.updateTooltip();
        }

        public void onClick(double mouseX, double mouseY) {
            craftableOnly = this.isStateTriggered = !this.isStateTriggered;
            WorkbenchScreen.this.updateRecipes();
            this.updateTooltip();
        }

        private void updateTooltip() {
            this.setTooltip(Tooltip.create((Component)(this.isStateTriggered ? VANILLA_ONLY_CRAFTABLE : VANILLA_ALL_RECIPES)));
        }
    }

    private static class SearchNeighboursButton
    extends StateSwitchingButton {
        private static final Component SEARCH_NEIGHBOURS_OFF = Utils.translation("gui", "workbench.search_neighbours.off", new Object[0]);
        private static final Component SEARCH_NEIGHBOURS_ON = Utils.translation("gui", "workbench.search_neighbours.on", new Object[0]);

        public SearchNeighboursButton(int x, int y, int width, int height, boolean state) {
            super(x, y, width, height, state);
            this.updateTooltip();
        }

        public void onClick(double mouseX, double mouseY) {
            Network.getPlay().sendToServer((Object)new MessageWorkbench.SearchNeighbours());
        }

        public void setStateTriggered(boolean state) {
            boolean original = this.isStateTriggered();
            super.setStateTriggered(state);
            if (original != state) {
                this.updateTooltip();
            }
        }

        private void updateTooltip() {
            this.setTooltip(Tooltip.create((Component)(this.isStateTriggered ? SEARCH_NEIGHBOURS_ON : SEARCH_NEIGHBOURS_OFF)));
        }
    }

    public class CategoryButton
    extends Button {
        private final int iconU;
        private final int iconV;
        private final Category category;

        protected CategoryButton(int x, int y, int iconU, int iconV, Category category) {
            super(x, y, 20, 16, CommonComponents.EMPTY, btn -> ((CategoryButton)btn).toggle(), DEFAULT_NARRATION);
            this.iconU = iconU;
            this.iconV = iconV;
            this.category = category;
            this.updateTooltip();
        }

        private void updateTooltip() {
            if (this.category.tags.length > 0) {
                ResourceLocation tagId = this.category.tags[0].location();
                String tooltipTitle = String.format("filterCategory.%s.%s", tagId.getNamespace(), tagId.getPath().replace("/", "."));
                String tooltipDesc = tooltipTitle + ".desc";
                this.setTooltip(ScreenHelper.createMultilineTooltip(List.of(Component.translatable((String)tooltipTitle), Component.translatable((String)tooltipDesc).withStyle(ChatFormatting.GRAY))));
            } else {
                this.setTooltip(Tooltip.create((Component)Components.GUI_SHOW_ALL_CATEGORIES));
            }
        }

        private void toggle() {
            CATEGORIES.forEach(c -> c.setEnabled(false));
            this.category.enabled = true;
            WorkbenchScreen.this.updateRecipes();
            WorkbenchScreen.this.updateScroll();
        }

        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int textureV = this.isHovered ? 87 : (this.category.enabled ? 71 : 55);
            graphics.blit(RenderPipelines.GUI_TEXTURED, WORKBENCH_TEXTURE, this.getX(), this.getY(), 216.0f, (float)textureV, 20, 16, 256, 256);
            graphics.blit(RenderPipelines.GUI_TEXTURED, WORKBENCH_TEXTURE, this.getX() + 3, this.getY() + 1, (float)this.iconU, (float)this.iconV, 14, 14, 256, 256);
        }
    }
}

