/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.mail;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.furniture.refurbished.blockentity.MailboxBlockEntity;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryService;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public final class Mailbox
implements IMailbox {
    public static final int MAX_NAME_LENGTH = 32;
    private static final Codec<Queue<ItemStack>> ITEMSTACK_QUEUE_CODEC = ItemStack.CODEC.listOf().flatXmap(list -> DataResult.success(new ArrayDeque(list)), queue -> DataResult.success(new ArrayList(queue)));
    public static final Codec<Mailbox> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.CODEC.fieldOf("UUID").forGetter(Mailbox::id), (App)ResourceKey.codec((ResourceKey)Registries.DIMENSION).fieldOf("Level").forGetter(Mailbox::levelKey), (App)BlockPos.CODEC.fieldOf("BlockPosition").forGetter(Mailbox::pos), (App)ITEMSTACK_QUEUE_CODEC.fieldOf("Queue").forGetter(Mailbox::queue), (App)UUIDUtil.CODEC.optionalFieldOf("Owner").forGetter(Mailbox::owner), (App)Codec.string((int)0, (int)32).optionalFieldOf("CustomName").orElse(Optional.of("Mailbox")).forGetter(Mailbox::customName)).apply((Applicative)instance, Mailbox::new));
    private final UUID id;
    private final ResourceKey<Level> levelKey;
    private final BlockPos pos;
    private final Queue<ItemStack> queue;
    private Optional<UUID> owner;
    private Optional<String> customName;
    private DeliveryService service;
    private boolean removed;

    public Mailbox(UUID id, ResourceKey<Level> levelKey, BlockPos pos, Queue<ItemStack> queue, Optional<UUID> owner, Optional<String> customName) {
        this.id = id;
        this.levelKey = levelKey;
        this.pos = pos;
        this.queue = queue;
        this.owner = owner;
        this.customName = customName;
    }

    public Mailbox(UUID id, ResourceKey<Level> levelKey, BlockPos pos) {
        this(id, levelKey, pos, new ArrayDeque<ItemStack>(), Optional.empty(), Optional.empty());
    }

    public void setService(DeliveryService service) {
        if (this.service == null) {
            this.service = service;
        }
    }

    public boolean rename(String customName) {
        if (!customName.isBlank() && customName.length() <= 32) {
            this.customName = Optional.of(customName);
            this.service.setDirty();
            return true;
        }
        return false;
    }

    public boolean hasOwner() {
        return this.owner.isPresent();
    }

    public void setOwner(UUID uuid) {
        this.owner = Optional.of(uuid);
        this.service.setDirty();
    }

    public boolean removed() {
        return this.removed;
    }

    void tick(DeliveryService service) {
        if (this.removed) {
            return;
        }
        MinecraftServer server = service.getServer();
        ServerLevel level = server.getLevel(this.levelKey);
        if (level == null || !level.isLoaded(this.pos)) {
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof MailboxBlockEntity) {
            MailboxBlockEntity blockEntity2 = (MailboxBlockEntity)blockEntity;
            if (blockEntity2.getMailbox().stream().noneMatch(mailbox -> mailbox == this)) {
                service.removeMailbox(this);
                this.removed = true;
                return;
            }
            if (this.queue.isEmpty()) {
                return;
            }
            ItemStack stack = this.queue.peek();
            if (blockEntity2.deliverItem(stack)) {
                this.queue.remove();
                service.setDirty();
            }
        } else {
            service.removeMailbox(this);
            this.removed = true;
        }
    }

    public void writeQueue(ValueOutput output) {
        ValueOutput.TypedOutputList list = output.list("Queue", ItemStack.CODEC);
        this.queue.forEach(stack -> {
            if (!stack.isEmpty()) {
                list.add(stack);
            }
        });
    }

    public static Queue<ItemStack> readQueueListTag(ValueInput input) {
        ArrayDeque<ItemStack> queue = new ArrayDeque<ItemStack>();
        input.list("Queue", ItemStack.CODEC).ifPresent(items -> items.forEach(stack -> {
            if (!stack.isEmpty()) {
                queue.offer((ItemStack)stack);
            }
        }));
        return queue;
    }

    void spawnQueueIntoLevel(DeliveryService service) {
        ServerLevel level = service.getServer().getLevel(this.levelKey);
        if (level != null) {
            Queue<ItemStack> queue = this.queue;
            while (!queue.isEmpty()) {
                ItemStack stack = queue.poll();
                Containers.dropItemStack((Level)level, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), (ItemStack)stack);
            }
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Mailbox mailbox = (Mailbox)obj;
        return this.id.equals(mailbox.id);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public Optional<GameProfile> getOwner() {
        GameProfileCache cache;
        UUID ownerId = this.owner.orElse(null);
        if (ownerId != null && (cache = this.service.getServer().getProfileCache()) != null) {
            return cache.get(ownerId);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getCustomName() {
        return this.customName;
    }

    public UUID id() {
        return this.id;
    }

    public ResourceKey<Level> levelKey() {
        return this.levelKey;
    }

    public BlockPos pos() {
        return this.pos;
    }

    public Optional<UUID> owner() {
        return this.owner;
    }

    public Optional<String> customName() {
        return this.customName;
    }

    public Queue<ItemStack> queue() {
        return this.queue;
    }
}

