/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.mrcrayfish.furniture.refurbished.block.DoorMatBlock;
import com.mrcrayfish.furniture.refurbished.blockentity.DoorMatBlockEntity;
import com.mrcrayfish.furniture.refurbished.image.TextureCache;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class DoorMatBlockEntityRenderer
implements BlockEntityRenderer<DoorMatBlockEntity> {
    public DoorMatBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DoorMatBlockEntity doorMat, float partialTick, PoseStack poseStack, MultiBufferSource source, int light, int overlay, Vec3 camera) {
        BlockState state = doorMat.getBlockState();
        if (!state.hasProperty((Property)DoorMatBlock.DIRECTION)) {
            return;
        }
        RenderType renderType = TextureCache.get().getRenderType(doorMat);
        if (renderType != null) {
            Direction direction = (Direction)state.getValue((Property)DoorMatBlock.DIRECTION);
            poseStack.translate(0.5, 0.0, 0.5);
            poseStack.mulPose((Quaternionfc)Axis.YN.rotation(1.5707964f * (float)direction.get2DDataValue()));
            poseStack.mulPose((Quaternionfc)Axis.YP.rotation((float)Math.PI));
            poseStack.translate(-0.5, 0.0, -0.5);
            VertexConsumer consumer = source.getBuffer(renderType);
            Matrix4f matrix = poseStack.last().pose();
            consumer.addVertex(matrix, 0.0625f, 0.063f, 0.1875f).setColor(255, 255, 255, 255).setUv(0.0f, 0.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 0.0625f, 0.063f, 0.8125f).setColor(255, 255, 255, 255).setUv(0.0f, 1.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 0.9375f, 0.063f, 0.8125f).setColor(255, 255, 255, 255).setUv(1.0f, 1.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
            consumer.addVertex(matrix, 0.9375f, 0.063f, 0.1875f).setColor(255, 255, 255, 255).setUv(1.0f, 0.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        }
    }

    public int getViewDistance() {
        return 24;
    }
}

