/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IModuleNode;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public abstract class ElectricityModuleBlockEntity
extends BlockEntity
implements IModuleNode {
    protected final Set<Connection> connections = new HashSet<Connection>();
    protected final Set<BlockPos> powerSources = new HashSet<BlockPos>();
    protected boolean receivingPower;

    public ElectricityModuleBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public Level getNodeLevel() {
        return this.level;
    }

    @Override
    public BlockPos getNodePosition() {
        return this.worldPosition;
    }

    @Override
    public BlockEntity getNodeOwner() {
        return this;
    }

    @Override
    public Set<Connection> getNodeConnections() {
        return this.connections;
    }

    @Override
    public void setNodeReceivingPower(boolean state) {
        this.receivingPower = state;
    }

    @Override
    public boolean isNodeReceivingPower() {
        return this.receivingPower;
    }

    @Override
    public Set<BlockPos> getPowerSources() {
        return this.powerSources;
    }

    protected void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.readNodeNbt(input);
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeNodeNbt(output);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.worldPosition).inflate((double)((Integer)Config.CLIENT.electricityViewDistance.get()).intValue());
    }

    public int hashCode() {
        return this.worldPosition.hashCode();
    }

    public void removeComponentsFromTag(ValueOutput output) {
        output.discard("Connections");
        output.discard("NodePos");
        output.discard("Powered");
        output.discard("Overloaded");
    }
}

